/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.BasePathChangeViewer;
import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class TracChangeViewer
extends BasePathChangeViewer {
    private TracChangeViewer() {
        super(null, null);
    }

    public TracChangeViewer(String baseURL, String projectPath) {
        super(baseURL, projectPath);
    }

    public String getDetails() {
        return "Trac [" + this.getBaseURL() + "]";
    }

    public String getChangesetURL(Revision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "changeset", revision.getRevisionString()});
    }

    public String getFileViewURL(String path, FileRevision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "browser", path + "?rev=" + revision.getRevisionString()});
    }

    public String getFileDownloadURL(String path, FileRevision revision) {
        return this.getFileViewURL(path, revision) + "&format=raw";
    }

    public String getFileDiffURL(String path, FileRevision revision) {
        FileRevision previous = revision.getPrevious();
        if (previous == null) {
            return null;
        }
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "changeset?new=" + this.getDiffPath(path, revision) + "&old=" + this.getDiffPath(path, previous)});
    }

    public ChangeViewer copy() {
        return new TracChangeViewer(this.getBaseURL(), this.getProjectPath());
    }

    private String getDiffPath(String path, FileRevision revision) {
        String result = StringUtils.join((String)"/", (String[])new String[]{path + "@" + revision.getRevisionString()});
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        try {
            return URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return result;
        }
    }
}

