/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.VariableHelper;
import com.zutubi.pulse.core.model.Property;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.scm.SCMServer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagPostBuildAction
extends PostBuildAction {
    private String tag;
    private boolean moveExisting;

    public TagPostBuildAction() {
    }

    public TagPostBuildAction(String name, List<BuildSpecification> specifications, List<ResultState> states, boolean failOnError, String tag, boolean moveExisting) {
        super(name, specifications, states, failOnError);
        this.tag = tag;
        this.moveExisting = moveExisting;
    }

    @Override
    protected void internalExecute(BuildResult result, RecipeResultNode recipe, List<ResourceProperty> properties) {
        try {
            String tagName = this.substituteVariables(this.tag, result, recipe, properties);
            SCMServer server = result.getProject().getScm().createServer();
            server.tag(result.getScmDetails().getRevision(), tagName, this.moveExisting);
        }
        catch (Exception e) {
            this.addError(e.getMessage());
        }
    }

    @Override
    public String getType() {
        return "apply tag";
    }

    @Override
    public PostBuildAction copy() {
        TagPostBuildAction copy = new TagPostBuildAction();
        this.copyCommon(copy);
        copy.tag = this.tag;
        copy.moveExisting = this.moveExisting;
        return copy;
    }

    private String substituteVariables(String tag, BuildResult build, RecipeResultNode recipe, List<ResourceProperty> properties) throws FileLoadException {
        Scope scope = new Scope();
        scope.add(properties);
        scope.add((Reference)new Property("project", build.getProject().getName()));
        scope.add((Reference)new Property("number", Long.toString(build.getNumber())));
        scope.add((Reference)new Property("specification", build.getBuildSpecification()));
        if (recipe == null) {
            scope.add((Reference)new Property("status", build.getState().getString()));
        } else {
            scope.add((Reference)new Property("status", recipe.getResult().getState().getString()));
        }
        return VariableHelper.replaceVariables((String)tag, (Scope)scope);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean getMoveExisting() {
        return this.moveExisting;
    }

    public void setMoveExisting(boolean moveExisting) {
        this.moveExisting = moveExisting;
    }
}

