/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.VariableHelper;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.Property;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.TestResultSummary;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildScmDetails;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.util.IOUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunExecutablePostBuildAction
extends PostBuildAction {
    private String command;
    private String arguments;
    private MasterConfigurationManager configurationManager;

    public RunExecutablePostBuildAction() {
    }

    public RunExecutablePostBuildAction(String name, List<BuildSpecification> specifications, List<ResultState> states, boolean failOnError, String command, String arguments) {
        super(name, specifications, states, failOnError);
        this.command = command;
        this.arguments = arguments;
    }

    @Override
    protected void internalExecute(BuildResult build, RecipeResultNode recipe, List<ResourceProperty> properties) {
        try {
            LinkedList<String> commandLine = new LinkedList<String>();
            commandLine.add(this.command);
            this.addArguments(commandLine, build, recipe, properties);
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            Process child = builder.start();
            IOUtils.joinStreams((InputStream)child.getInputStream(), (OutputStream)System.out);
            int code = child.waitFor();
            if (code != 0) {
                this.addError("Command exited with non-zero exit code (" + code + ")");
            }
        }
        catch (Exception e) {
            this.addError(e.getMessage());
        }
    }

    @Override
    public String getType() {
        return "run executable";
    }

    @Override
    public PostBuildAction copy() {
        RunExecutablePostBuildAction copy = new RunExecutablePostBuildAction();
        this.copyCommon(copy);
        copy.command = this.command;
        copy.arguments = this.arguments;
        return copy;
    }

    private void addArguments(List<String> commandLine, BuildResult build, RecipeResultNode recipe, List<ResourceProperty> properties) throws FileLoadException {
        Scope scope = RunExecutablePostBuildAction.getScope(build, recipe, properties, this.configurationManager);
        commandLine.addAll(VariableHelper.splitAndReplaceVariables((String)this.arguments, (Scope)scope, (boolean)true));
    }

    public static Scope getScope(BuildResult result, RecipeResultNode recipe, List<ResourceProperty> properties, MasterConfigurationManager configurationManager) {
        MasterBuildPaths paths = new MasterBuildPaths(configurationManager);
        Scope scope = new Scope();
        scope.add(properties);
        scope.add((Reference)new Property("project", result.getProject().getName()));
        scope.add((Reference)new Property("number", Long.toString(result.getNumber())));
        BuildScmDetails buildScmDetails = result.getScmDetails();
        if (buildScmDetails != null && buildScmDetails.getRevision() != null) {
            scope.add((Reference)new Property("revision", buildScmDetails.getRevision().getRevisionString()));
        }
        scope.add((Reference)new Property("specification", result.getBuildSpecification()));
        scope.add((Reference)new Property("build.dir", paths.getBuildDir(result).getAbsolutePath()));
        if (recipe == null) {
            scope.add((Reference)new Property("status", result.getState().getString()));
            scope.add((Reference)new Property("reason", result.getReason().getSummary()));
            TestResultSummary tests = result.getTestSummary();
            String testSummary = tests.getTotal() > 0 ? (tests.allPassed() ? "all " + tests.getTotal() + " tests passed" : Integer.toString(tests.getBroken()) + " of " + tests.getTotal() + " tests broken") : "no tests";
            scope.add((Reference)new Property("test.summary", testSummary));
            for (RecipeResultNode node : result.getRoot().getChildren()) {
                RunExecutablePostBuildAction.addStageProperties(result, node, scope, paths, configurationManager, true);
            }
        } else {
            RunExecutablePostBuildAction.addStageProperties(result, recipe, scope, paths, configurationManager, false);
        }
        return scope;
    }

    private static void addStageProperties(BuildResult result, RecipeResultNode node, Scope scope, MasterBuildPaths paths, MasterConfigurationManager configurationManager, boolean includeName) {
        String name = node.getStage();
        String prefix = "stage.";
        if (includeName) {
            prefix = prefix + name + ".";
        }
        RecipeResult recipeResult = node.getResult();
        scope.add((Reference)new Property(prefix + "agent", node.getHostSafe()));
        if (result != null) {
            scope.add((Reference)new Property(prefix + "recipe", recipeResult.getRecipeNameSafe()));
            scope.add((Reference)new Property(prefix + "status", recipeResult.getState().getString()));
            scope.add((Reference)new Property(prefix + "dir", paths.getRecipeDir(result, recipeResult.getId()).getAbsolutePath()));
            for (CommandResult command : recipeResult.getCommandResults()) {
                RunExecutablePostBuildAction.addCommandProperties(node, command, scope, configurationManager, includeName);
            }
        }
    }

    private static void addCommandProperties(RecipeResultNode node, CommandResult commandResult, Scope scope, MasterConfigurationManager configurationManager, boolean includeName) {
        String stageName = node.getStage();
        String commandName = commandResult.getCommandName();
        String prefix = "";
        if (includeName) {
            prefix = "stage." + stageName + ".";
        }
        prefix = prefix + "command." + commandName + ".";
        scope.add((Reference)new Property(prefix + "status", commandResult.getState().getString()));
        scope.add((Reference)new Property(prefix + "dir", commandResult.getAbsoluteOutputDir(configurationManager.getDataDirectory()).getAbsolutePath()));
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

