/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.TestResultSummary;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeResultNode
extends Entity {
    private PersistentName stageName;
    private String host;
    private RecipeResult result;
    private List<RecipeResultNode> children;

    public RecipeResultNode() {
    }

    public RecipeResultNode(PersistentName stageName, RecipeResult result) {
        this.stageName = stageName;
        this.result = result;
        this.children = new LinkedList<RecipeResultNode>();
    }

    public String getStage() {
        return this.stageName.getName();
    }

    public PersistentName getStageName() {
        return this.stageName;
    }

    private void setStageName(PersistentName stageName) {
        this.stageName = stageName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHostSafe() {
        if (this.host == null) {
            return "[pending]";
        }
        return this.host;
    }

    public RecipeResult getResult() {
        return this.result;
    }

    private void setResult(RecipeResult result) {
        this.result = result;
    }

    public List<RecipeResultNode> getChildren() {
        return this.children;
    }

    private void setChildren(List<RecipeResultNode> children) {
        this.children = children;
    }

    public void addChild(RecipeResultNode child) {
        this.children.add(child);
    }

    public void abort() {
        if (!this.result.completed()) {
            this.result.error("Recipe aborted");
            this.result.abortUnfinishedCommands();
            this.result.complete();
        }
        for (RecipeResultNode child : this.children) {
            child.abort();
        }
    }

    public List<String> collectErrors() {
        LinkedList<String> errors = new LinkedList<String>();
        errors.addAll(this.result.collectErrors());
        for (RecipeResultNode child : this.children) {
            errors.addAll(child.collectErrors());
        }
        return errors;
    }

    public boolean hasMessages(Feature.Level level) {
        if (this.result.hasMessages(level)) {
            return true;
        }
        for (RecipeResultNode child : this.children) {
            if (!child.hasMessages(level)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArtifacts() {
        if (this.result.hasArtifacts()) {
            return true;
        }
        for (RecipeResultNode child : this.children) {
            if (!child.hasArtifacts()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBrokenTests() {
        return this.getTestSummary().getBroken() > 0;
    }

    public TestResultSummary getTestSummary() {
        TestResultSummary summary = new TestResultSummary();
        this.accumulateTestSummary(summary);
        return summary;
    }

    public void accumulateTestSummary(TestResultSummary summary) {
        if (this.result != null) {
            this.result.accumulateTestSummary(summary);
        }
        for (RecipeResultNode r : this.children) {
            r.accumulateTestSummary(summary);
        }
    }

    public RecipeResultNode findNode(long id) {
        if (id == this.getId()) {
            return this;
        }
        for (RecipeResultNode child : this.children) {
            RecipeResultNode found = child.findNode(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public RecipeResultNode findNode(PersistentName stageName) {
        if (stageName.equals((Object)this.stageName)) {
            return this;
        }
        for (RecipeResultNode child : this.children) {
            RecipeResultNode found = child.findNode(stageName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public RecipeResultNode findNode(String stageName) {
        if (this.stageName != null && stageName.equals(this.stageName.getName())) {
            return this;
        }
        for (RecipeResultNode child : this.children) {
            RecipeResultNode found = child.findNode(stageName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public ResultState getWorstState(ResultState worst) {
        if (this.result != null) {
            worst = ResultState.getWorseState((ResultState)worst, (ResultState)this.result.getState());
        }
        for (RecipeResultNode child : this.children) {
            worst = child.getWorstState(worst);
        }
        return worst;
    }

    public void loadFailedTestResults(File dataRoot, int limit) {
        if (this.result != null) {
            this.result.loadFailedTestResults(dataRoot, limit);
        }
        for (RecipeResultNode child : this.children) {
            child.loadFailedTestResults(dataRoot, limit);
        }
    }

    public StoredArtifact findArtifact(String artifactName) {
        StoredArtifact artifact = this.result.getArtifact(artifactName);
        if (artifact != null) {
            return artifact;
        }
        for (RecipeResultNode child : this.children) {
            artifact = child.findArtifact(artifactName);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }
}

