/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.model.BuildHostRequirements;
import com.zutubi.pulse.model.BuildReason;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.model.EntityManager;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.scheduling.SchedulingException;
import java.util.List;
import org.acegisecurity.annotation.Secured;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ProjectManager
extends EntityManager<Project> {
    public Project getProject(String var1);

    public Project getProject(long var1);

    public Project getProjectByScm(long var1);

    public Project getProjectByBuildSpecification(BuildSpecification var1);

    public List<Project> getAllProjects();

    public List<Project> getAllProjectsCached();

    public List<Project> getProjectsWithNameLike(String var1);

    public int getProjectCount();

    @Override
    public void save(BuildSpecification var1);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public void setDefaultBuildSpecification(Project var1, long var2);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public void deleteBuildSpecification(Project var1, long var2);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public void deleteArtifact(Project var1, long var2);

    public void buildCommenced(long var1);

    public void buildCompleted(long var1);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public Project pauseProject(Project var1);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public void resumeProject(Project var1);

    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void create(Project var1) throws LicenseException;

    @Override
    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void delete(Project var1);

    @Override
    @Secured(value={"ROLE_ADMINISTRATOR", "ACL_PROJECT_WRITE"})
    public void save(Project var1);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public void checkWrite(Project var1);

    @Secured(value={"ROLE_ADMINISTRATOR"})
    public Project cloneProject(Project var1, String var2, String var3);

    @Secured(value={"ACL_PROJECT_WRITE"})
    public void updateProjectDetails(Project var1, String var2, String var3, String var4) throws SchedulingException;

    @Secured(value={"ROLE_ADMINISTRATOR"})
    public List<Project> getProjectsWithAdmin(String var1);

    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void updateProjectAdmins(String var1, List<Long> var2);

    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void removeAcls(String var1);

    public void triggerBuild(Project var1, String var2, BuildReason var3, Revision var4, boolean var5);

    public void triggerBuild(long var1, Project var3, BuildSpecification var4, User var5, PatchArchive var6) throws PulseException;

    public long getNextBuildNumber(Project var1);

    public List<ProjectGroup> getAllProjectGroups();

    public List<ProjectGroup> getAllProjectGroupsCached();

    public ProjectGroup getProjectGroup(long var1);

    public ProjectGroup getProjectGroup(String var1);

    @Override
    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void save(ProjectGroup var1);

    @Override
    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void delete(ProjectGroup var1);

    public Project getProjectByCleanupRule(CleanupRule var1);

    public BuildSpecification getBuildSpecification(long var1);

    @Override
    public void delete(BuildHostRequirements var1);
}

