/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.ProjectAclEntry;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.model.VersionedPulseFileDetails;
import java.util.LinkedList;
import java.util.List;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.AclObjectIdentityAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Entity
implements AclObjectIdentity,
AclObjectIdentityAware,
NamedEntity {
    private String name;
    private String description;
    private String url;
    private PulseFileDetails pulseFileDetails;
    private List<PostBuildAction> postBuildActions = new LinkedList<PostBuildAction>();
    private List<CleanupRule> cleanupRules = new LinkedList<CleanupRule>();
    private Scm scm;
    private ChangeViewer changeViewer;
    private State state = State.IDLE;
    private long nextBuildNumber = 1L;
    private List<BuildSpecification> buildSpecifications;
    private BuildSpecification defaultSpecification;
    private List<ProjectAclEntry> aclEntries;

    public Project() {
    }

    public Project(String name, String description) {
        this(name, description, new VersionedPulseFileDetails("pulse.xml"));
    }

    public Project(String name, String description, PulseFileDetails pulseFileDetails) {
        this.name = name;
        this.description = description;
        this.pulseFileDetails = pulseFileDetails;
    }

    public Project copy(String name, String description) {
        Project copy = new Project();
        copy.name = name;
        copy.description = description;
        copy.url = this.url;
        copy.pulseFileDetails = this.pulseFileDetails.copy();
        copy.cleanupRules = new LinkedList<CleanupRule>();
        for (CleanupRule rule : this.cleanupRules) {
            copy.cleanupRules.add(rule.copy());
        }
        copy.scm = this.scm.copy();
        if (this.changeViewer != null) {
            copy.changeViewer = this.changeViewer.copy();
        }
        copy.buildSpecifications = new LinkedList<BuildSpecification>();
        for (BuildSpecification spec : this.buildSpecifications) {
            BuildSpecification specCopy = spec.copy();
            copy.buildSpecifications.add(specCopy);
            if (!spec.equals((Object)this.defaultSpecification)) continue;
            copy.defaultSpecification = specCopy;
        }
        copy.postBuildActions = new LinkedList<PostBuildAction>();
        for (PostBuildAction action : this.postBuildActions) {
            copy.postBuildActions.add(action.copy());
        }
        for (PostBuildAction action : copy.postBuildActions) {
            LinkedList<BuildSpecification> copiedSpecs = new LinkedList<BuildSpecification>();
            block4: for (BuildSpecification originalSpec : action.getSpecifications()) {
                for (BuildSpecification copiedSpec : copy.buildSpecifications) {
                    if (!copiedSpec.getName().equals(originalSpec.getName())) continue;
                    copiedSpecs.add(copiedSpec);
                    continue block4;
                }
            }
            action.setSpecifications(copiedSpecs);
        }
        copy.aclEntries = new LinkedList<ProjectAclEntry>();
        for (ProjectAclEntry acl : this.getAclEntries()) {
            copy.aclEntries.add(acl.copy(copy));
        }
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Scm getScm() {
        return this.scm;
    }

    public void setScm(Scm scm) {
        this.scm = scm;
    }

    public ChangeViewer getChangeViewer() {
        return this.changeViewer;
    }

    public void setChangeViewer(ChangeViewer changeViewer) {
        this.changeViewer = changeViewer;
    }

    public List<BuildSpecification> getBuildSpecifications() {
        if (this.buildSpecifications == null) {
            this.buildSpecifications = new LinkedList<BuildSpecification>();
        }
        return this.buildSpecifications;
    }

    public void addBuildSpecification(BuildSpecification specification) {
        this.getBuildSpecifications().add(specification);
    }

    private void setBuildSpecifications(List<BuildSpecification> buildSpecifications) {
        this.buildSpecifications = buildSpecifications;
    }

    public BuildSpecification getBuildSpecification(long id) {
        for (BuildSpecification s : this.buildSpecifications) {
            if (s.getId() != id) continue;
            return s;
        }
        return null;
    }

    public BuildSpecification getBuildSpecification(String name) {
        for (BuildSpecification spec : this.buildSpecifications) {
            if (spec.getName().compareToIgnoreCase(name) != 0) continue;
            return spec;
        }
        return null;
    }

    public boolean remove(BuildSpecification buildSpecification) {
        return this.buildSpecifications.remove((Object)buildSpecification);
    }

    public BuildSpecification getDefaultSpecification() {
        return this.defaultSpecification;
    }

    public void setDefaultSpecification(BuildSpecification defaultSpecification) {
        this.defaultSpecification = defaultSpecification;
    }

    public List<Long> getBuildSpecificationIds() {
        LinkedList<Long> ids = new LinkedList<Long>();
        for (BuildSpecification spec : this.buildSpecifications) {
            ids.add(spec.getId());
        }
        return ids;
    }

    public List<BuildSpecification> lookupBuildSpecifications(List<Long> ids) {
        LinkedList<BuildSpecification> result = new LinkedList<BuildSpecification>();
        if (ids != null) {
            for (Long id : ids) {
                BuildSpecification buildSpecification = this.getBuildSpecification(id);
                if (buildSpecification == null) continue;
                result.add(buildSpecification);
            }
        }
        return result;
    }

    public PulseFileDetails getPulseFileDetails() {
        return this.pulseFileDetails;
    }

    public void setPulseFileDetails(PulseFileDetails pulseFileDetails) {
        this.pulseFileDetails = pulseFileDetails;
    }

    public List<PostBuildAction> getPostBuildActions() {
        return this.postBuildActions;
    }

    private void setPostBuildActions(List<PostBuildAction> postBuildActions) {
        this.postBuildActions = postBuildActions;
    }

    public void addPostBuildAction(PostBuildAction action) {
        this.postBuildActions.add(action);
    }

    public void removePostBuildAction(long id) {
        PostBuildAction deadActionWalking = null;
        for (PostBuildAction action : this.postBuildActions) {
            if (action.getId() != id) continue;
            deadActionWalking = action;
            break;
        }
        if (deadActionWalking != null) {
            this.postBuildActions.remove((Object)deadActionWalking);
        }
    }

    public PostBuildAction getPostBuildAction(String name) {
        for (PostBuildAction p : this.postBuildActions) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public PostBuildAction getPostBuildAction(long id) {
        for (PostBuildAction a : this.postBuildActions) {
            if (a.getId() != id) continue;
            return a;
        }
        return null;
    }

    public List<CleanupRule> getCleanupRules() {
        return this.cleanupRules;
    }

    private void setCleanupRules(List<CleanupRule> cleanupRules) {
        this.cleanupRules = cleanupRules;
    }

    public void addCleanupRule(CleanupRule rule) {
        this.cleanupRules.add(rule);
    }

    public CleanupRule getCleanupRule(long id) {
        for (CleanupRule rule : this.cleanupRules) {
            if (rule.getId() != id) continue;
            return rule;
        }
        return null;
    }

    public void removeCleanupRule(long id) {
        CleanupRule deadRuleWalking = this.getCleanupRule(id);
        if (deadRuleWalking != null) {
            this.cleanupRules.remove((Object)deadRuleWalking);
        }
    }

    public State getState() {
        return this.state;
    }

    private String getStateName() {
        return this.state.toString();
    }

    private void setStateName(String stateName) {
        this.state = State.valueOf(stateName);
    }

    public synchronized boolean isPaused() {
        return this.state == State.PAUSED || this.state == State.PAUSING;
    }

    public synchronized void buildCommenced() {
        this.state = State.BUILDING;
    }

    public synchronized void buildCompleted() {
        this.state = this.state == State.PAUSING ? State.PAUSED : State.IDLE;
    }

    public synchronized void pause() {
        switch (this.state) {
            case BUILDING: {
                this.state = State.PAUSING;
                break;
            }
            case IDLE: {
                this.state = State.PAUSED;
            }
        }
    }

    public synchronized void resume() {
        switch (this.state) {
            case PAUSED: {
                this.state = State.IDLE;
                break;
            }
            case PAUSING: {
                this.state = State.BUILDING;
            }
        }
    }

    public AclObjectIdentity getAclObjectIdentity() {
        return this;
    }

    public List<ProjectAclEntry> getAclEntries() {
        if (this.aclEntries == null) {
            this.aclEntries = new LinkedList<ProjectAclEntry>();
        }
        return this.aclEntries;
    }

    private void setAclEntries(List<ProjectAclEntry> aclEntries) {
        this.aclEntries = aclEntries;
    }

    public boolean hasAdmin(String login) {
        for (ProjectAclEntry acl : this.getAclEntries()) {
            if (!acl.getRecipient().equals(login)) continue;
            return true;
        }
        return false;
    }

    public void addAdmin(String recipient) {
        if (!this.hasAdmin(recipient)) {
            this.getAclEntries().add(new ProjectAclEntry(recipient, this, ProjectAclEntry.WRITE));
        }
    }

    public void removeAdmin(String login) {
        ProjectAclEntry remove = null;
        for (ProjectAclEntry entry : this.getAclEntries()) {
            if (!entry.getRecipient().equals(login)) continue;
            remove = entry;
            break;
        }
        if (remove != null) {
            this.getAclEntries().remove((Object)remove);
        }
    }

    public long getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public void setNextBuildNumber(long nextBuildNumber) {
        this.nextBuildNumber = nextBuildNumber;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        BUILDING,
        IDLE,
        PAUSED,
        PAUSING;

    }
}

