/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.util.logging.Logger;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PostBuildAction
extends Entity {
    private static final Logger LOG = Logger.getLogger(PostBuildAction.class);
    private String name;
    private List<BuildSpecification> specifications = new LinkedList<BuildSpecification>();
    private List<ResultState> states = new LinkedList<ResultState>();
    private boolean failOnError = false;
    private List<String> errors;

    protected PostBuildAction() {
    }

    protected PostBuildAction(String name, List<BuildSpecification> specifications, List<ResultState> states, boolean failOnError) {
        this.name = name;
        this.specifications = specifications;
        this.states = states;
        this.failOnError = failOnError;
    }

    protected void copyCommon(PostBuildAction copy) {
        copy.name = this.name;
        copy.specifications = new LinkedList<BuildSpecification>(this.specifications);
        copy.states = new LinkedList<ResultState>(this.states);
        copy.failOnError = this.failOnError;
    }

    public void execute(BuildResult build, RecipeResultNode recipe, List<ResourceProperty> properties) {
        this.errors = new LinkedList<String>();
        if (this.resultMatches(build)) {
            this.internalExecute(build, recipe, properties);
            for (String error : this.errors) {
                if (this.failOnError) {
                    if (recipe == null) {
                        build.error(error);
                        continue;
                    }
                    recipe.getResult().error(error);
                    continue;
                }
                LOG.warning(error);
            }
        }
    }

    private boolean resultMatches(BuildResult result) {
        return this.specMatches(result) && this.stateMatches(result);
    }

    private boolean specMatches(BuildResult result) {
        if (this.specifications == null || this.specifications.size() == 0) {
            return true;
        }
        for (BuildSpecification spec : this.specifications) {
            if (!spec.getName().equals(result.getBuildSpecification())) continue;
            return true;
        }
        return false;
    }

    private boolean stateMatches(BuildResult result) {
        if (this.states == null || this.states.size() == 0) {
            return true;
        }
        for (ResultState state : this.states) {
            if (!state.equals((Object)result.getState())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BuildSpecification> getSpecifications() {
        return this.specifications;
    }

    public void setSpecifications(List<BuildSpecification> specifications) {
        this.specifications = specifications;
    }

    public List<Long> getBuildSpecificationIds() {
        LinkedList<Long> ids = new LinkedList<Long>();
        for (BuildSpecification spec : this.specifications) {
            ids.add(spec.getId());
        }
        return ids;
    }

    public List<ResultState> getStates() {
        return this.states;
    }

    public void setStates(List<ResultState> states) {
        this.states = states;
    }

    public String getStatesString() {
        return ResultState.getStatesString(this.states);
    }

    public void setStatesString(String value) {
        this.states = ResultState.getStatesList((String)value);
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected void addError(String error) {
        this.errors.add("Executing post build action '" + this.name + "': " + error);
    }

    protected abstract void internalExecute(BuildResult var1, RecipeResultNode var2, List<ResourceProperty> var3);

    public abstract String getType();

    public abstract PostBuildAction copy();
}

