/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakePulseFileDetails
extends TemplatePulseFileDetails {
    private String makefile;
    private String targets;
    private String arguments;
    private String workingDir;
    private Map<String, String> environment = new TreeMap<String, String>();

    public MakePulseFileDetails() {
        this.makefile = null;
        this.targets = null;
        this.arguments = null;
        this.workingDir = null;
    }

    public MakePulseFileDetails(String buildFile, String targets, String arguments, String workingDir) {
        this.makefile = buildFile;
        this.targets = targets;
        this.arguments = arguments;
        this.workingDir = workingDir;
    }

    @Override
    public MakePulseFileDetails copy() {
        MakePulseFileDetails copy = new MakePulseFileDetails(this.makefile, this.targets, this.arguments, this.workingDir);
        copy.environment = new TreeMap<String, String>(this.environment);
        this.copyCommon(copy);
        return copy;
    }

    @Override
    protected String getTemplateName() {
        return "make.template.vm";
    }

    @Override
    protected void populateContext(VelocityContext context) {
        if (TextUtils.stringSet((String)this.makefile)) {
            context.put("makefile", (Object)this.makefile);
        }
        if (TextUtils.stringSet((String)this.targets)) {
            context.put("targets", (Object)this.targets);
        }
        if (TextUtils.stringSet((String)this.arguments)) {
            context.put("arguments", (Object)this.arguments);
        }
        if (TextUtils.stringSet((String)this.workingDir)) {
            context.put("workingDir", (Object)this.workingDir);
        }
        context.put("environment", this.environment);
    }

    public String getMakefile() {
        return this.makefile;
    }

    public void setMakefile(String makefile) {
        this.makefile = makefile;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void addEnvironmentalVariable(String name, String value) {
        this.environment.put(name, value);
    }

    @Override
    public String getType() {
        return "make";
    }

    @Override
    public Properties getProperties() {
        String env;
        Properties result = new Properties();
        if (TextUtils.stringSet((String)this.makefile)) {
            result.put("makefile", this.makefile);
        }
        if (TextUtils.stringSet((String)this.targets)) {
            result.put("targets", this.targets);
        }
        if (TextUtils.stringSet((String)this.workingDir)) {
            result.put("working directory", this.workingDir);
        }
        if (TextUtils.stringSet((String)this.arguments)) {
            result.put("arguments", this.arguments);
        }
        if (TextUtils.stringSet((String)(env = this.getEnvironmentString()))) {
            result.put("environment", env);
        }
        return result;
    }

    private String getEnvironmentString() {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            result.append(sep);
            result.append((Object)entry.getKey());
            result.append('=');
            result.append((Object)entry.getValue());
            sep = "; ";
        }
        return result.toString();
    }
}

