/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.CvsRevision;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.BasePathChangeViewer;
import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.model.CustomChangeViewer;
import com.zutubi.pulse.util.StringUtils;

public class FisheyeChangeViewer
extends BasePathChangeViewer {
    private FisheyeChangeViewer() {
        super(null, null);
    }

    public FisheyeChangeViewer(String baseURL, String projectPath) {
        super(baseURL, projectPath);
    }

    public String getDetails() {
        return "Fisheye [" + this.getBaseURL() + "]";
    }

    public String getChangesetURL(Revision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "changelog", this.getProjectPath(), "?cs=" + this.getChangesetString(revision)});
    }

    public String getFileViewURL(String path, FileRevision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "browse", this.getProjectPath(), path + "?r=" + revision.getRevisionString()});
    }

    public String getFileDownloadURL(String path, FileRevision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "browse", "~raw,r=" + revision.getRevisionString(), this.getProjectPath(), path});
    }

    public String getFileDiffURL(String path, FileRevision revision) {
        FileRevision previousRevision = revision.getPrevious();
        if (previousRevision == null) {
            return null;
        }
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "browse", this.getProjectPath(), path + "?r1=" + previousRevision.getRevisionString() + "&r2=" + revision.getRevisionString()});
    }

    public ChangeViewer copy() {
        return new FisheyeChangeViewer(this.getBaseURL(), this.getProjectPath());
    }

    private String getChangesetString(Revision revision) {
        if (revision instanceof CvsRevision) {
            CvsRevision cvs = (CvsRevision)revision;
            return String.format("%s:%s:%s", cvs.getBranch(), cvs.getAuthor(), CustomChangeViewer.FISHEYE_DATE_FORMAT.format(revision.getDate()));
        }
        return revision.getRevisionString();
    }
}

