/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.Capture;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryCapture
extends Capture {
    private String base;
    private String includes;
    private String excludes;
    private String mimeType;

    private DirectoryCapture() {
        super(null);
    }

    public DirectoryCapture(String name) {
        this(name, null, null);
    }

    @Override
    public DirectoryCapture copy() {
        DirectoryCapture copy = new DirectoryCapture();
        this.copyCommon(copy);
        copy.base = this.base;
        copy.excludes = this.excludes;
        copy.includes = this.includes;
        copy.mimeType = this.mimeType;
        return copy;
    }

    public DirectoryCapture(String name, String base) {
        this(name, base, null);
    }

    public DirectoryCapture(String name, String base, String mimeType) {
        super(name);
        this.base = base;
        this.mimeType = mimeType;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getType() {
        return "directory";
    }

    @Override
    public void clearFields() {
        if (!TextUtils.stringSet((String)this.base)) {
            this.base = null;
        }
        if (!TextUtils.stringSet((String)this.mimeType)) {
            this.mimeType = null;
        }
    }

    public List<String> getIncludePatterns() {
        return this.getPatterns(this.getIncludes());
    }

    public List<String> getExcludePatterns() {
        return this.getPatterns(this.getExcludes());
    }

    private List<String> getPatterns(String cludes) {
        if (TextUtils.stringSet((String)cludes)) {
            return Arrays.asList(cludes.split(" +"));
        }
        return new LinkedList<String>();
    }
}

