/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.license.LicenseManager;
import com.zutubi.pulse.license.authorisation.AddUserAuthorisation;
import com.zutubi.pulse.model.AcegiUser;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.model.persistence.ContactPointDao;
import com.zutubi.pulse.model.persistence.GroupDao;
import com.zutubi.pulse.model.persistence.UserDao;
import com.zutubi.pulse.security.ldap.LdapManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUserManager
implements UserManager {
    private UserDao userDao;
    private ContactPointDao contactPointDao;
    private GroupDao groupDao;
    private PasswordEncoder passwordEncoder;
    private LicenseManager licenseManager;
    private BuildManager buildManager;
    private LdapManager ldapManager;

    public void init() {
        AddUserAuthorisation addUserAuthorisation = new AddUserAuthorisation();
        addUserAuthorisation.setUserManager(this);
        this.licenseManager.addAuthorisation(addUserAuthorisation);
    }

    @Override
    public void save(User user) {
        this.userDao.save(user);
    }

    @Override
    public void save(ContactPoint contact) {
        this.contactPointDao.save(contact);
    }

    public boolean hasAuthority(User user, String authority) {
        if (user.hasAuthority(authority)) {
            return true;
        }
        List<Group> groups = this.groupDao.findByMember(user);
        for (Group g : groups) {
            if (!g.hasAuthority(authority)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addUser(User newUser, boolean grantAdminPermissions, boolean useLdapAuthencation) {
        newUser.add("ROLE_USER");
        if (grantAdminPermissions) {
            newUser.add("ROLE_ADMINISTRATOR");
        }
        newUser.setEnabled(true);
        newUser.setDefaultAction("welcome");
        newUser.setLdapAuthentication(useLdapAuthencation);
        this.save(newUser);
        this.setPassword(newUser, newUser.getPassword());
        this.save(newUser);
        this.licenseManager.refreshAuthorisations();
    }

    @Override
    public User getUser(String login) {
        return this.userDao.findByLogin(login);
    }

    @Override
    public User getUser(long id) {
        return (User)((Object)this.userDao.findById(id));
    }

    @Override
    public List<User> getUsersWithLoginLike(String login) {
        return this.userDao.findByLikeLogin(login);
    }

    @Override
    public List<User> getAllUsers() {
        return this.userDao.findAll();
    }

    @Override
    public ContactPoint getContactPoint(long id) {
        return (ContactPoint)((Object)this.contactPointDao.findById(id));
    }

    @Override
    public void delete(User user) {
        this.getBuildManager().deleteAllBuilds(user);
        List<Group> groups = this.groupDao.findByMember(user);
        for (Group group : groups) {
            group.getUsers().remove((Object)user);
            this.groupDao.save(group);
        }
        this.userDao.delete(user);
        this.licenseManager.refreshAuthorisations();
    }

    @Override
    public void delete(ContactPoint contact) {
        this.contactPointDao.delete(contact);
    }

    @Override
    public List<Group> getAllGroups() {
        return this.groupDao.findAll();
    }

    @Override
    public List<Group> getAdminAllProjectGroups() {
        return this.groupDao.findByAdminAllProjects();
    }

    @Override
    public Group getGroup(long id) {
        return (Group)((Object)this.groupDao.findById(id));
    }

    @Override
    public Group getGroup(String name) {
        return this.groupDao.findByName(name);
    }

    @Override
    public void addGroup(Group group) {
        this.groupDao.save(group);
    }

    @Override
    public void save(Group group) {
        this.groupDao.save(group);
    }

    @Override
    public void renameGroup(Group group, String newName) {
        group.setName(newName);
        this.groupDao.save(group);
    }

    @Override
    public void delete(Group group, ProjectManager projectManager) {
        projectManager.removeAcls(group.getDefaultAuthority());
        this.groupDao.delete(group);
    }

    @Override
    public List<User> getUsersNotInGroup(Group group) {
        return this.userDao.findByNotInGroup(group);
    }

    @Override
    public long getNextBuildNumber(User user) {
        user = this.getUser(user.getId());
        long number = user.getNextBuildNumber();
        user.setNextBuildNumber(number + 1L);
        this.save(user);
        return number;
    }

    @Override
    public Set<Project> getUserProjects(User user, ProjectManager projectManager) {
        HashSet<Project> projects = new HashSet<Project>();
        if (user.getShowAllProjects()) {
            projects.addAll(projectManager.getAllProjects());
        } else {
            user = (User)((Object)this.userDao.findById(user.getId()));
            projects.addAll(user.getShownProjects());
            for (ProjectGroup g : user.getShownGroups()) {
                projects.addAll(g.getProjects());
            }
        }
        return projects;
    }

    @Override
    public AcegiUser getPrinciple(User user) {
        AcegiUser principle = new AcegiUser(user);
        user.getGroups();
        this.getLdapManager().addLdapRoles(principle);
        return principle;
    }

    @Override
    public void removeReferencesToProject(Project project) {
        List<User> users = this.userDao.findByShownProject(project);
        for (User u : users) {
            u.getShownProjects().remove((Object)project);
            this.userDao.save(u);
        }
    }

    @Override
    public void removeReferencesToProjectGroup(ProjectGroup projectGroup) {
        List<User> users = this.userDao.findByShownProjectGroup(projectGroup);
        for (User u : users) {
            u.getShownGroups().remove((Object)projectGroup);
            this.userDao.save(u);
        }
    }

    @Override
    public int getUserCount() {
        return this.userDao.count();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User user = this.userDao.findByLogin(username);
        if (user == null) {
            throw new UsernameNotFoundException("Unknown user");
        }
        AcegiUser details = new AcegiUser(user);
        return details;
    }

    @Override
    public void setPassword(User user, String rawPassword) {
        String encodedPassword = this.passwordEncoder.encodePassword(rawPassword, null);
        user.setPassword(encodedPassword);
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setContactPointDao(ContactPointDao contactDao) {
        this.contactPointDao = contactDao;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.groupDao = groupDao;
    }

    public BuildManager getBuildManager() {
        if (this.buildManager == null) {
            this.buildManager = (BuildManager)ComponentContext.getBean((String)"buildManager");
        }
        return this.buildManager;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public LdapManager getLdapManager() {
        if (this.ldapManager == null) {
            this.ldapManager = (LdapManager)ComponentContext.getBean((String)"ldapManager");
        }
        return this.ldapManager;
    }

    public void setLdapManager(LdapManager ldapManager) {
        this.ldapManager = ldapManager;
    }
}

