/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectBuildSubscription;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.SubscriptionManager;
import com.zutubi.pulse.model.persistence.SubscriptionDao;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionManager
implements SubscriptionManager {
    private SubscriptionDao subscriptionDao;

    public void setSubscriptionDao(SubscriptionDao dao) {
        this.subscriptionDao = dao;
    }

    @Override
    public void save(Subscription subscription) {
        this.subscriptionDao.save(subscription);
    }

    @Override
    public void delete(Subscription subscription) {
        subscription.getContactPoint().remove(subscription);
        this.subscriptionDao.delete(subscription);
    }

    @Override
    public Subscription getSubscription(long id) {
        return (Subscription)((Object)this.subscriptionDao.findById(id));
    }

    @Override
    public List<Subscription> getSubscriptions(Project project) {
        List<Subscription> subscriptions = this.subscriptionDao.findByProject(project);
        subscriptions.addAll(this.subscriptionDao.findByNoProject());
        return subscriptions;
    }

    @Override
    public void deleteAllSubscriptions(Project project) {
        List<Subscription> suscriptions = this.subscriptionDao.findByProject(project);
        for (Subscription s : suscriptions) {
            if (!(s instanceof ProjectBuildSubscription)) continue;
            ProjectBuildSubscription pbs = (ProjectBuildSubscription)s;
            List<Project> projects = pbs.getProjects();
            projects.remove((Object)project);
            if (projects.size() != 0) continue;
            this.delete(s);
        }
    }
}

