/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.model.BuildHostRequirements;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.BuildStage;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveBuildHostRequirements;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.model.persistence.BuildSpecificationDao;
import com.zutubi.pulse.model.persistence.SlaveDao;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.SimpleTrigger;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.tasks.PingSlaves;
import com.zutubi.pulse.util.logging.Logger;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSlaveManager
implements SlaveManager {
    private static final Logger LOG = Logger.getLogger(DefaultSlaveManager.class);
    private SlaveDao slaveDao;
    private BuildSpecificationDao buildSpecificationDao;
    private Scheduler scheduler;
    private ProjectManager projectManager;
    private static final String PING_NAME = "ping";
    private static final String PING_GROUP = "services";
    private static final long PING_FREQUENCY = 60000L;

    public void init() {
        Trigger trigger = this.scheduler.getTrigger(PING_NAME, PING_GROUP);
        if (trigger != null) {
            return;
        }
        trigger = new SimpleTrigger(PING_NAME, PING_GROUP, 60000L);
        trigger.setTaskClass(PingSlaves.class);
        try {
            this.scheduler.schedule(trigger);
        }
        catch (SchedulingException e) {
            LOG.severe((Throwable)((Object)e));
        }
    }

    @Override
    public Slave getSlave(String name) {
        return this.slaveDao.findByName(name);
    }

    @Override
    public List<Slave> getAll() {
        return this.slaveDao.findAll();
    }

    @Override
    public Slave getSlave(long id) {
        return (Slave)((Object)this.slaveDao.findById(id));
    }

    @Override
    public void delete(long id) {
        Slave slave = (Slave)((Object)this.slaveDao.findById(id));
        if (slave != null) {
            List<BuildSpecification> buildSpecs = this.buildSpecificationDao.findBySlave(slave);
            for (BuildSpecification spec : buildSpecs) {
                this.removeStages(spec.getRoot(), id);
                if (spec.getRoot().getChildren().size() == 0) {
                    this.projectManager.deleteBuildSpecification(this.projectManager.getProjectByBuildSpecification(spec), spec.getId());
                    continue;
                }
                this.projectManager.save(spec);
            }
            this.slaveDao.delete(slave);
        }
    }

    private void removeStages(BuildSpecificationNode node, long id) {
        LinkedList<BuildSpecificationNode> dead = new LinkedList<BuildSpecificationNode>();
        for (BuildSpecificationNode child : node.getChildren()) {
            BuildHostRequirements hostRequirements;
            BuildStage stage = child.getStage();
            if (stage != null && (hostRequirements = stage.getHostRequirements()) instanceof SlaveBuildHostRequirements && ((SlaveBuildHostRequirements)hostRequirements).getSlave().getId() == id) {
                dead.add(child);
            }
            this.removeStages(child, id);
        }
        node.getChildren().removeAll(dead);
    }

    @Override
    public void delete(Slave slave) {
        this.slaveDao.delete(slave);
    }

    @Override
    public void save(Slave slave) {
        this.slaveDao.save(slave);
    }

    public void setSlaveDao(SlaveDao slaveDao) {
        this.slaveDao = slaveDao;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setBuildSpecificationDao(BuildSpecificationDao buildSpecificationDao) {
        this.buildSpecificationDao = buildSpecificationDao;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }
}

