/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.ShutdownManager;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.model.Cvs;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.model.ScmManager;
import com.zutubi.pulse.model.persistence.ScmDao;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.SimpleTrigger;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scm.MonitorScms;
import com.zutubi.pulse.scm.SCMChangeEvent;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.util.Pair;
import com.zutubi.pulse.util.logging.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScmManager
implements ScmManager,
Stoppable {
    private static final Logger LOG = Logger.getLogger(DefaultScmManager.class);
    private ScmDao scmDao = null;
    private EventManager eventManager;
    private ShutdownManager shutdownManager;
    private Scheduler scheduler;
    private static final String MONITOR_NAME = "poll";
    private static final String MONITOR_GROUP = "scm";
    private static final long POLLING_FREQUENCY = 60000L;
    private MasterConfigurationManager configManager;
    private final Map<Long, Pair<Long, Revision>> waiting = new HashMap<Long, Pair<Long, Revision>>();
    private final Map<Long, Revision> latestRevisions = new HashMap<Long, Revision>();
    private ThreadPoolExecutor executor = null;
    private static final int DEFAULT_POLL_THREAD_COUNT = 10;
    private static final String PROPERTY_POLLING_THREAD_COUNT = "scm.polling.thread.count";

    public void setScmDao(ScmDao scmDao) {
        this.scmDao = scmDao;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setConfigurationManager(MasterConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public void init() {
        int pollThreadCount = 10;
        if (System.getProperties().contains(PROPERTY_POLLING_THREAD_COUNT)) {
            pollThreadCount = Integer.getInteger(PROPERTY_POLLING_THREAD_COUNT);
        }
        this.executor = new ThreadPoolExecutor(pollThreadCount, pollThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.shutdownManager.addStoppable((Stoppable)this);
        Trigger trigger = this.scheduler.getTrigger(MONITOR_NAME, MONITOR_GROUP);
        if (trigger != null) {
            return;
        }
        trigger = new SimpleTrigger(MONITOR_NAME, MONITOR_GROUP, 60000L);
        trigger.setTaskClass(MonitorScms.class);
        try {
            this.scheduler.schedule(trigger);
        }
        catch (SchedulingException e) {
            LOG.severe((Throwable)((Object)e));
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void stop(boolean force) {
        this.shutdown();
    }

    @Override
    public List<Scm> getActiveScms() {
        return this.scmDao.findAllActive();
    }

    @Override
    public void pollActiveScms() {
        for (final Scm scm : this.getActiveScms()) {
            this.executor.execute(new Runnable(){

                public void run() {
                    long start = System.currentTimeMillis();
                    DefaultScmManager.this.process(scm);
                    long end = System.currentTimeMillis();
                    LOG.debug("Scm polling took " + (end - start) / 1000L + " seconds.");
                }
            });
        }
        while (this.executor.getActiveCount() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void process(Scm scm) {
        try {
            long now = System.currentTimeMillis();
            if (!this.checkPollingInterval(scm, now)) {
                return;
            }
            scm.setLastPollTime(Long.valueOf(now));
            this.save(scm);
            SCMServer server = scm.createServer();
            if (!this.latestRevisions.containsKey(scm.getId())) {
                this.latestRevisions.put(scm.getId(), server.getLatestRevision());
                return;
            }
            Revision previous = this.latestRevisions.get(scm.getId());
            if (previous == null) {
                this.latestRevisions.put(scm.getId(), server.getLatestRevision());
                return;
            }
            if (scm instanceof Cvs) {
                Cvs cvs = (Cvs)scm;
                if (this.waiting.containsKey(scm.getId())) {
                    long quietTime = (Long)this.waiting.get((Object)Long.valueOf((long)scm.getId())).first;
                    if (quietTime < System.currentTimeMillis()) {
                        Revision lastChange = (Revision)this.waiting.get((Object)Long.valueOf((long)scm.getId())).second;
                        Revision latest = this.getLatestRevisionSince(lastChange, server);
                        if (latest != null) {
                            this.waiting.put(scm.getId(), new Pair<Long, Revision>(System.currentTimeMillis() + cvs.getQuietPeriod(), latest));
                        } else {
                            this.sendScmChangeEvent(scm, lastChange, previous);
                            this.waiting.remove(scm.getId());
                        }
                    }
                } else {
                    Revision latest = this.getLatestRevisionSince(previous, server);
                    if (latest != null) {
                        if (cvs.getQuietPeriod() != 0L) {
                            this.waiting.put(scm.getId(), new Pair<Long, Revision>(System.currentTimeMillis() + cvs.getQuietPeriod(), latest));
                        } else {
                            this.sendScmChangeEvent(scm, latest, previous);
                        }
                    }
                }
            } else {
                Revision latest = this.getLatestRevisionSince(previous, server);
                if (latest != null) {
                    this.sendScmChangeEvent(scm, latest, previous);
                }
            }
        }
        catch (SCMException e) {
            LOG.warning(e.getMessage(), (Throwable)e);
        }
    }

    private Revision getLatestRevisionSince(Revision revision, SCMServer server) throws SCMException {
        List revisions = server.getRevisionsSince(revision);
        if (revisions.size() > 0) {
            return (Revision)revisions.get(revisions.size() - 1);
        }
        return null;
    }

    private void sendScmChangeEvent(Scm scm, Revision latest, Revision previous) {
        if (latest != null && previous != null && latest.compareTo(previous) == 0) {
            LOG.warning("Scm monitoring detected that the previous change revision '" + previous + "' is the same as " + "the latest change revision '" + latest + "', and will therefore ignore this change.");
            return;
        }
        LOG.finer("publishing scm change event for " + scm + " revision " + latest);
        this.eventManager.publish((Event)new SCMChangeEvent(scm, latest, previous));
        this.latestRevisions.put(scm.getId(), latest);
    }

    private boolean checkPollingInterval(Scm scm, long now) {
        if (scm.getLastPollTime() != null) {
            long lastPollTime;
            long nextPollTime;
            int pollingInterval = this.getDefaultPollingInterval();
            if (scm.getPollingInterval() != null) {
                pollingInterval = scm.getPollingInterval();
            }
            if (now < (nextPollTime = (lastPollTime = scm.getLastPollTime().longValue()) + 60000L * (long)pollingInterval)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void save(Scm entity) {
        this.scmDao.save(entity);
    }

    @Override
    public void delete(Scm entity) {
        this.scmDao.delete(entity);
    }

    @Override
    public Scm getScm(long id) {
        return (Scm)this.scmDao.findById(id);
    }

    @Override
    public int getDefaultPollingInterval() {
        return this.configManager.getAppConfig().getScmPollingInterval();
    }

    @Override
    public void setDefaultPollingInterval(int interval) {
        this.configManager.getAppConfig().setScmPollingInterval(interval);
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setShutdownManager(ShutdownManager shutdownManager) {
        this.shutdownManager = shutdownManager;
    }
}

