/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.BuildCompletedEvent;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildScmDetails;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.model.HistoryPage;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.TestManager;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.persistence.ArtifactDao;
import com.zutubi.pulse.model.persistence.BuildResultDao;
import com.zutubi.pulse.model.persistence.ChangelistDao;
import com.zutubi.pulse.model.persistence.FileArtifactDao;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.SimpleTrigger;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.tasks.CleanupBuilds;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildManager
implements BuildManager,
EventListener {
    private static final Logger LOG = Logger.getLogger(DefaultBuildManager.class);
    private BuildResultDao buildResultDao;
    private ArtifactDao artifactDao;
    private FileArtifactDao fileArtifactDao;
    private ChangelistDao changelistDao;
    private ProjectManager projectManager;
    private Scheduler scheduler;
    private MasterConfigurationManager configurationManager;
    private EventManager eventManager;
    private TestManager testManager;
    private DatabaseConsole databaseConsole;
    private static final String CLEANUP_NAME = "cleanup";
    private static final String CLEANUP_GROUP = "services";
    private static final long CLEANUP_FREQUENCY = 3600000L;
    private static final Map<Project, Object> runningCleanups = new HashMap<Project, Object>();

    public void init() {
        this.eventManager.register((EventListener)this);
        Trigger trigger = this.scheduler.getTrigger(CLEANUP_NAME, CLEANUP_GROUP);
        if (trigger != null) {
            return;
        }
        trigger = new SimpleTrigger(CLEANUP_NAME, CLEANUP_GROUP, 3600000L);
        trigger.setTaskClass(CleanupBuilds.class);
        try {
            this.scheduler.schedule(trigger);
        }
        catch (SchedulingException e) {
            LOG.severe((Throwable)((Object)e));
        }
    }

    public void setBuildResultDao(BuildResultDao dao) {
        this.buildResultDao = dao;
    }

    public void setArtifactDao(ArtifactDao dao) {
        this.artifactDao = dao;
    }

    @Override
    public void save(BuildResult buildResult) {
        this.buildResultDao.save(buildResult);
    }

    @Override
    public void save(RecipeResultNode node) {
        this.buildResultDao.save(node);
    }

    @Override
    public void save(RecipeResult result) {
        this.buildResultDao.save(result);
    }

    @Override
    public void save(Changelist changelist) {
        this.changelistDao.save(changelist);
    }

    @Override
    public BuildResult getBuildResult(long id) {
        return (BuildResult)this.buildResultDao.findById(id);
    }

    @Override
    public RecipeResultNode getRecipeResultNode(long id) {
        return this.buildResultDao.findRecipeResultNode(id);
    }

    @Override
    public RecipeResultNode getResultNodeByResultId(long id) {
        return this.buildResultDao.findResultNodeByResultId(id);
    }

    @Override
    public RecipeResult getRecipeResult(long id) {
        return this.buildResultDao.findRecipeResult(id);
    }

    @Override
    public List<BuildResult> getLatestBuildResultsForProject(Project project, int max) {
        return this.buildResultDao.findLatestByProject(project, max);
    }

    @Override
    public int getBuildCount(Project project, ResultState[] states, PersistentName spec) {
        return this.buildResultDao.getBuildCount(project, states, spec);
    }

    @Override
    public void fillHistoryPage(HistoryPage page) {
        this.fillHistoryPage(page, new ResultState[]{ResultState.ERROR, ResultState.FAILURE, ResultState.SUCCESS}, null);
    }

    @Override
    public List<PersistentName> getBuildSpecifications(Project project) {
        return this.buildResultDao.findAllSpecifications(project);
    }

    @Override
    public void fillHistoryPage(HistoryPage page, ResultState[] states, PersistentName spec) {
        page.setTotalBuilds(this.buildResultDao.getBuildCount(page.getProject(), states, spec));
        page.setResults(this.buildResultDao.findLatestByProject(page.getProject(), states, spec, page.getFirst(), page.getMax()));
    }

    @Override
    public List<BuildResult> getLatestCompletedBuildResults(Project project, PersistentName spec, int max) {
        return this.getLatestCompletedBuildResults(project, spec, 0, max);
    }

    @Override
    public List<BuildResult> getLatestCompletedBuildResults(Project project, PersistentName spec, int first, int max) {
        return this.buildResultDao.findLatestCompleted(project, spec, first, max);
    }

    @Override
    public BuildResult getByProjectAndNumber(Project project, long number) {
        return this.buildResultDao.findByProjectAndNumber(project, number);
    }

    @Override
    public BuildResult getByUserAndNumber(User user, long id) {
        return this.buildResultDao.findByUserAndNumber(user, id);
    }

    @Override
    public CommandResult getCommandResult(long id) {
        return this.buildResultDao.findCommandResult(id);
    }

    @Override
    public StoredArtifact getArtifact(long id) {
        return (StoredArtifact)this.artifactDao.findById(id);
    }

    @Override
    public StoredFileArtifact getFileArtifact(long id) {
        return (StoredFileArtifact)this.fileArtifactDao.findById(id);
    }

    @Override
    public List<BuildResult> getPersonalBuilds(User user) {
        return this.buildResultDao.findByUser(user);
    }

    @Override
    public BuildResult getLatestBuildResult(User user) {
        List<BuildResult> results = this.buildResultDao.getLatestByUser(user, null, 1);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public List<BuildResult> queryBuilds(Project[] projects, ResultState[] states, PersistentName[] specs, long earliestStartTime, long latestStartTime, Boolean hasWorkDir, int first, int max, boolean mostRecentFirst) {
        return this.buildResultDao.queryBuilds(projects, states, specs, earliestStartTime, latestStartTime, hasWorkDir, first, max, mostRecentFirst);
    }

    @Override
    public List<BuildResult> querySpecificationBuilds(Project project, PersistentName spec, ResultState[] states, long lowestNumber, long highestNumber, int first, int max, boolean mostRecentFirst, boolean initialise) {
        return this.buildResultDao.querySpecificationBuilds(project, spec, states, lowestNumber, highestNumber, first, max, mostRecentFirst, initialise);
    }

    @Override
    public void cleanupBuilds() {
        List<Project> projects = this.projectManager.getAllProjects();
        for (Project project : projects) {
            this.cleanupBuilds(project);
        }
        if (this.databaseConsole.isEmbedded() && this.databaseConsole.getDatabaseUsagePercent() > 95.0) {
            LOG.warning("The internal database is close to reaching its size limit.  Consider adding more cleanup rules to remove old build information.");
        }
    }

    @Override
    public Revision getPreviousRevision(Project project, PersistentName specification) {
        List<BuildResult> previousBuildResults;
        Revision previousRevision = null;
        int offset = 0;
        while ((previousBuildResults = this.getLatestCompletedBuildResults(project, specification, offset, 1)).size() == 1) {
            BuildScmDetails previousScmDetails;
            BuildResult previous = previousBuildResults.get(0);
            if (!previous.isUserRevision() && (previousScmDetails = previous.getScmDetails()) != null) {
                previousRevision = previousScmDetails.getRevision();
                break;
            }
            ++offset;
        }
        return previousRevision;
    }

    @Override
    public List<Changelist> getLatestChangesForUser(User user, int max) {
        return this.changelistDao.findLatestByUser(user, max);
    }

    @Override
    public List<Changelist> getLatestChangesForProject(Project project, int max) {
        return this.changelistDao.findLatestByProject(project, max);
    }

    @Override
    public List<Changelist> getLatestChangesForProjects(Project[] projects, int max) {
        return this.changelistDao.findLatestByProjects(projects, max);
    }

    @Override
    public List<Changelist> getChangesForBuild(BuildResult result) {
        return this.changelistDao.findByResult(result.getId());
    }

    @Override
    public void deleteAllBuilds(Project project) {
        List<BuildResult> results;
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File projectDir = paths.getProjectDir(project);
        if (!FileSystemUtils.rmdir((File)projectDir)) {
            LOG.warning("Unable to remove project directory '" + projectDir.getAbsolutePath() + "'");
        }
        do {
            results = this.buildResultDao.findOldestByProject(project, null, 100, true);
            for (BuildResult r : results) {
                this.cleanupResult(r);
            }
        } while (results.size() > 0);
    }

    @Override
    public void deleteAllBuilds(User user) {
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File userDir = paths.getUserDir(user.getId());
        if (!FileSystemUtils.rmdir((File)userDir)) {
            LOG.warning("Unable to remove user directory '" + userDir.getAbsolutePath() + "'");
        }
        List<BuildResult> results = this.buildResultDao.findByUser(user);
        for (BuildResult r : results) {
            this.cleanupResult(r);
        }
    }

    @Override
    public Changelist getChangelistByRevision(String serverUid, Revision revision) {
        return this.changelistDao.findByRevision(serverUid, revision);
    }

    @Override
    public void delete(BuildResult result) {
        this.cleanupResult(result);
    }

    @Override
    public void abortUnfinishedBuilds(Project project, String message) {
        List<BuildResult> incompleteBuilds = this.queryBuilds(new Project[]{project}, ResultState.getIncompleteStates(), null, -1L, -1L, null, -1, -1, true);
        for (BuildResult r : incompleteBuilds) {
            this.abortBuild(r, message);
        }
    }

    @Override
    public void abortUnfinishedBuilds(User user, String message) {
        List<BuildResult> incompleteBuilds = this.buildResultDao.getLatestByUser(user, ResultState.getIncompleteStates(), -1);
        for (BuildResult r : incompleteBuilds) {
            this.abortBuild(r, message);
        }
    }

    private void abortBuild(BuildResult build, String message) {
        if (build != null && !build.completed()) {
            build.abortUnfinishedRecipes();
            build.error(message);
            build.complete();
            build.calculateFeatureCounts();
            this.save(build);
        }
    }

    @Override
    public boolean isSpaceAvailableForBuild() {
        if (this.databaseConsole.isEmbedded()) {
            return this.databaseConsole.getDatabaseUsagePercent() < 99.5;
        }
        return true;
    }

    @Override
    public BuildResult getPreviousBuildResult(BuildResult result) {
        return this.buildResultDao.findPreviousBuildResult(result);
    }

    @Override
    public boolean isCleanupInProgress(Project project) {
        return runningCleanups.containsKey((Object)project);
    }

    @Override
    public CommandResult getCommandResultByArtifact(long artifactId) {
        return this.buildResultDao.findCommandResultByArtifact(artifactId);
    }

    @Override
    public CommandResult getCommandResult(long recipeResultId, String commandName) {
        return this.buildResultDao.findRecipeResult(recipeResultId).getCommandResult(commandName);
    }

    @Override
    public StoredArtifact getArtifact(long buildId, String artifactName) {
        BuildResult result = (BuildResult)this.buildResultDao.findById(buildId);
        return result.findArtifact(artifactName);
    }

    @Override
    public StoredArtifact getCommandResultByArtifact(long commandResultId, String artifactName) {
        return this.buildResultDao.findCommandResult(commandResultId).getArtifact(artifactName);
    }

    @Override
    public Boolean canDecorateArtifact(long artifactId) {
        StoredFileArtifact artifact = this.getFileArtifact(artifactId);
        return artifact != null && artifact.canDecorate();
    }

    @Override
    public void executeInTransaction(Runnable runnable) {
        runnable.run();
    }

    @Override
    public BuildResult getLatestBuildResult(BuildSpecification spec) {
        return this.buildResultDao.findLatestByBuildSpec(spec);
    }

    @Override
    public BuildResult getLatestBuildResult(Project project) {
        List<BuildResult> results = this.getLatestBuildResultsForProject(project, 1);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public BuildResult getLatestBuildResult() {
        return this.buildResultDao.findLatest();
    }

    @Override
    public BuildResult getLatestSuccessfulBuildResult(BuildSpecification specification) {
        return this.buildResultDao.findLatestSuccessfulBySpecification(specification);
    }

    @Override
    public BuildResult getLatestSuccessfulBuildResult(Project project) {
        return this.buildResultDao.findLatestSuccessfulByProject(project);
    }

    @Override
    public BuildResult getLatestSuccessfulBuildResult() {
        return this.buildResultDao.findLatestSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupBuilds(Project project) {
        try {
            runningCleanups.put(project, null);
            List<CleanupRule> rules = project.getCleanupRules();
            for (CleanupRule rule : rules) {
                this.cleanupBuilds(rule, project);
            }
        }
        finally {
            runningCleanups.remove((Object)project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupBuilds(CleanupRule rule) {
        Project project = this.projectManager.getProjectByCleanupRule(rule);
        try {
            runningCleanups.put(project, null);
            this.cleanupBuilds(rule, project);
        }
        finally {
            runningCleanups.remove((Object)project);
        }
    }

    @Override
    public void cleanupBuilds(User user) {
        int max;
        int count = this.buildResultDao.getCompletedResultCount(user);
        if (count > (max = user.getMyBuildsCount())) {
            List<BuildResult> results = this.buildResultDao.getOldestCompletedBuilds(user, count - max);
            for (BuildResult result : results) {
                this.cleanupResult(result);
            }
        }
    }

    private synchronized void cleanupBuilds(CleanupRule rule, Project project) {
        List<BuildResult> oldBuilds = rule.getMatchingResults(project, this.buildResultDao);
        for (BuildResult build : oldBuilds) {
            if (rule.getWorkDirOnly()) {
                this.cleanupWork(build);
                continue;
            }
            this.cleanupResult(build);
        }
    }

    @Override
    public boolean canCancel(BuildResult build, User user) {
        if (build.isPersonal()) {
            return build.getUser().equals((Object)user);
        }
        try {
            this.projectManager.checkWrite(build.getProject());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void cleanupResult(BuildResult build) {
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File buildDir = paths.getBuildDir(build);
        if (buildDir.exists() && !FileSystemUtils.rmdir((File)buildDir)) {
            LOG.warning("Unable to clean up build directory '" + buildDir.getAbsolutePath() + "'");
            return;
        }
        if (build.isPersonal()) {
            File patch = paths.getUserPatchFile(build.getUser().getId(), build.getNumber());
            patch.delete();
        } else {
            BuildScmDetails scmDetails = build.getScmDetails();
            if (scmDetails != null) {
                List<Changelist> changelists = this.changelistDao.findByResult(build.getId());
                for (Changelist change : changelists) {
                    change.removeResultId(build.getId());
                    this.changelistDao.save(change);
                }
            }
        }
        this.buildResultDao.delete(build);
    }

    private void cleanupWork(BuildResult build) {
        build.setHasWorkDir(false);
        this.buildResultDao.save(build);
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        this.cleanupWorkForNodes(paths, build, build.getRoot().getChildren());
    }

    private void cleanupWorkForNodes(MasterBuildPaths paths, BuildResult build, List<RecipeResultNode> nodes) {
        for (RecipeResultNode node : nodes) {
            File workDir = paths.getBaseDir(build, node.getResult().getId());
            if (!FileSystemUtils.rmdir((File)workDir)) {
                LOG.warning("Unable to clean up build directory '" + workDir.getAbsolutePath() + "'");
            }
            this.cleanupWorkForNodes(paths, build, node.getChildren());
        }
    }

    public void handleEvent(Event evt) {
        BuildCompletedEvent completedEvent = (BuildCompletedEvent)evt;
        BuildResult result = completedEvent.getResult();
        if (result.isPersonal()) {
            this.cleanupBuilds(result.getUser());
        } else {
            this.cleanupBuilds(result.getProject());
        }
    }

    public Class[] getHandledEvents() {
        return new Class[]{BuildCompletedEvent.class};
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setChangelistDao(ChangelistDao changelistDao) {
        this.changelistDao = changelistDao;
    }

    public void setFileArtifactDao(FileArtifactDao fileArtifactDao) {
        this.fileArtifactDao = fileArtifactDao;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setTestManager(TestManager testManager) {
        this.testManager = testManager;
    }

    public void setDatabaseConsole(DatabaseConsole databaseConsole) {
        this.databaseConsole = databaseConsole;
    }
}

