/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.Reference;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.VariableHelper;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.Property;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.model.Scm;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class CustomChangeViewer
extends ChangeViewer {
    private static final String PROPERTY_REVISION = "revision";
    private static final String PROPERTY_PREVIOUS_REVISION = "previous.revision";
    private static final String PROPERTY_AUTHOR = "author";
    private static final String PROPERTY_BRANCH = "branch";
    private static final String PROPERTY_PATH = "path";
    private static final String PROPERTY_TIMESTAMP_PULSE = "time.pulse";
    private static final String PROPERTY_TIMESTAMP_FISHEYE = "time.fisheye";
    private static final SimpleDateFormat PULSE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
    public static final SimpleDateFormat FISHEYE_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private String changesetURL;
    private String fileViewURL;
    private String fileDownloadURL;
    private String fileDiffURL;

    public CustomChangeViewer() {
    }

    public CustomChangeViewer(String changesetUrl, String fileViewURL, String fileDownloadURL, String fileDiffURL) {
        this.changesetURL = changesetUrl;
        this.fileViewURL = fileViewURL;
        this.fileDownloadURL = fileDownloadURL;
        this.fileDiffURL = fileDiffURL;
    }

    public String getChangesetURL() {
        return this.changesetURL;
    }

    public void setChangesetURL(String changesetURL) {
        this.changesetURL = changesetURL;
    }

    public String getFileViewURL() {
        return this.fileViewURL;
    }

    public void setFileViewURL(String fileViewURL) {
        this.fileViewURL = fileViewURL;
    }

    public String getFileDownloadURL() {
        return this.fileDownloadURL;
    }

    public void setFileDownloadURL(String fileDownloadURL) {
        this.fileDownloadURL = fileDownloadURL;
    }

    public String getFileDiffURL() {
        return this.fileDiffURL;
    }

    public void setFileDiffURL(String fileDiffURL) {
        this.fileDiffURL = fileDiffURL;
    }

    public boolean hasCapability(Scm scm, ChangeViewer.Capability capability) {
        switch (capability) {
            case DOWNLOAD_FILE: {
                return TextUtils.stringSet((String)this.fileDownloadURL);
            }
            case VIEW_FILE: {
                return TextUtils.stringSet((String)this.fileViewURL);
            }
            case VIEW_FILE_DIFF: {
                return TextUtils.stringSet((String)this.fileDiffURL);
            }
            case VIEW_CHANGESET: {
                return TextUtils.stringSet((String)this.changesetURL);
            }
        }
        return false;
    }

    public String getDetails() {
        return "custom";
    }

    public String getChangesetURL(Revision revision) {
        return this.resolveURL(this.changesetURL, revision);
    }

    public String getFileViewURL(String path, FileRevision revision) {
        return this.resolveFileURL(this.fileViewURL, path, revision);
    }

    public String getFileDownloadURL(String path, FileRevision revision) {
        return this.resolveFileURL(this.fileViewURL, path, revision);
    }

    public String getFileDiffURL(String path, FileRevision revision) {
        if (revision.getPrevious() == null) {
            return null;
        }
        return this.resolveFileURL(this.fileViewURL, path, revision);
    }

    public ChangeViewer copy() {
        return new CustomChangeViewer(this.changesetURL, this.fileViewURL, this.fileDownloadURL, this.fileDiffURL);
    }

    private String resolveURL(String url, Revision revision) {
        if (TextUtils.stringSet((String)url)) {
            Scope scope = new Scope();
            scope.add((Reference)new Property(PROPERTY_REVISION, revision.getRevisionString()));
            scope.add((Reference)new Property(PROPERTY_AUTHOR, revision.getAuthor()));
            scope.add((Reference)new Property(PROPERTY_BRANCH, revision.getBranch()));
            if (revision.getDate() != null) {
                scope.add((Reference)new Property(PROPERTY_TIMESTAMP_PULSE, PULSE_DATE_FORMAT.format(revision.getDate())));
                scope.add((Reference)new Property(PROPERTY_TIMESTAMP_FISHEYE, FISHEYE_DATE_FORMAT.format(revision.getDate())));
            }
            try {
                return VariableHelper.replaceVariables((String)url, (Scope)scope, (boolean)true);
            }
            catch (FileLoadException e) {
                // empty catch block
            }
        }
        return null;
    }

    private String resolveFileURL(String url, String path, FileRevision revision) {
        if (TextUtils.stringSet((String)url)) {
            Scope scope = new Scope();
            scope.add((Reference)new Property(PROPERTY_PATH, path));
            scope.add((Reference)new Property(PROPERTY_REVISION, revision.getRevisionString()));
            FileRevision previous = revision.getPrevious();
            if (previous != null) {
                scope.add((Reference)new Property(PROPERTY_PREVIOUS_REVISION, previous.getRevisionString()));
            }
            try {
                return VariableHelper.replaceVariables((String)url, (Scope)scope, (boolean)true);
            }
            catch (FileLoadException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static void validateChangesetURL(String url) {
        Scope scope = new Scope();
        scope.add((Reference)new Property(PROPERTY_REVISION, ""));
        scope.add((Reference)new Property(PROPERTY_AUTHOR, ""));
        scope.add((Reference)new Property(PROPERTY_BRANCH, ""));
        scope.add((Reference)new Property(PROPERTY_TIMESTAMP_FISHEYE, ""));
        scope.add((Reference)new Property(PROPERTY_TIMESTAMP_PULSE, ""));
        try {
            VariableHelper.replaceVariables((String)url, (Scope)scope);
        }
        catch (FileLoadException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void validateFileURL(String url) {
        Scope scope = new Scope();
        scope.add((Reference)new Property(PROPERTY_PATH, ""));
        scope.add((Reference)new Property(PROPERTY_REVISION, ""));
        scope.add((Reference)new Property(PROPERTY_PREVIOUS_REVISION, ""));
        try {
            VariableHelper.replaceVariables((String)url, (Scope)scope);
        }
        catch (FileLoadException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static {
        FISHEYE_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

