/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.User;
import com.zutubi.validation.annotations.Required;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContactPoint
extends Entity
implements NamedEntity {
    private String name;
    private Properties properties;
    private String uid;
    private User user;
    private List<Subscription> subscriptions;
    private String lastError;

    public void setName(String name) {
        this.name = name;
    }

    @Required
    public String getName() {
        return this.name;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    protected String getStringProperty(String name) {
        return (String)this.getProperties().get(name);
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getLastError() {
        return this.lastError;
    }

    public boolean hasError() {
        return this.lastError != null;
    }

    private void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public void clearError() {
        this.lastError = null;
    }

    public List<Subscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new LinkedList<Subscription>();
        }
        return this.subscriptions;
    }

    public void add(Subscription subscription) {
        if (!this.getSubscriptions().contains((Object)subscription)) {
            this.getSubscriptions().add(subscription);
            subscription.setContactPoint(this);
        }
    }

    public void remove(Subscription subscription) {
        if (this.getSubscriptions().contains((Object)subscription)) {
            this.getSubscriptions().remove((Object)subscription);
            subscription.setContactPoint(null);
        }
    }

    private void setSubscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void notify(BuildResult result, String rendered, String mimeType) {
        block2: {
            this.lastError = null;
            try {
                this.internalNotify(result, rendered, mimeType);
            }
            catch (Exception e) {
                this.lastError = e.getClass().getName();
                if (e.getMessage() == null) break block2;
                this.lastError = this.lastError + ": " + e.getMessage();
            }
        }
    }

    public abstract String getDefaultTemplate();

    protected abstract void internalNotify(BuildResult var1, String var2, String var3) throws Exception;
}

