/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.BuildStage;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.ResourceRequirement;
import com.zutubi.pulse.util.Predicate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSpecificationNode
extends Entity {
    private BuildStage stage;
    private List<BuildSpecificationNode> children = new LinkedList<BuildSpecificationNode>();
    private List<ResourceRequirement> resourceRequirements = new LinkedList<ResourceRequirement>();
    private List<PostBuildAction> postActions = new LinkedList<PostBuildAction>();

    public BuildSpecificationNode() {
    }

    public BuildSpecificationNode(BuildStage stage) {
        this.stage = stage;
    }

    public BuildSpecificationNode copy() {
        BuildSpecificationNode copy = new BuildSpecificationNode();
        copy.stage = this.stage == null ? null : this.stage.copy();
        copy.resourceRequirements = new LinkedList<ResourceRequirement>();
        for (ResourceRequirement r : this.resourceRequirements) {
            copy.resourceRequirements.add(r.copy());
        }
        copy.children = new LinkedList<BuildSpecificationNode>();
        for (BuildSpecificationNode child : this.children) {
            copy.children.add(child.copy());
        }
        copy.postActions = new LinkedList<PostBuildAction>();
        for (PostBuildAction action : this.postActions) {
            copy.postActions.add(action.copy());
        }
        return copy;
    }

    public List<BuildSpecificationNode> getChildren() {
        return this.children;
    }

    private void setChildren(List<BuildSpecificationNode> children) {
        this.children = children;
    }

    public void addChild(BuildSpecificationNode child) {
        this.children.add(child);
    }

    public BuildStage getStage() {
        return this.stage;
    }

    public void setStage(BuildStage stage) {
        this.stage = stage;
    }

    public BuildSpecificationNode getNodeByPredicate(Predicate<BuildSpecificationNode> predicate) {
        if (predicate.satisfied((Object)this)) {
            return this;
        }
        for (BuildSpecificationNode child : this.children) {
            BuildSpecificationNode found = child.getNodeByPredicate(predicate);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void getNodesByPredicate(Predicate<BuildSpecificationNode> predicate, List<BuildSpecificationNode> nodes) {
        if (predicate.satisfied((Object)this)) {
            nodes.add(this);
        }
        for (BuildSpecificationNode child : this.children) {
            child.getNodesByPredicate(predicate, nodes);
        }
    }

    public BuildSpecificationNode getNode(final long id) {
        return this.getNodeByPredicate(new Predicate<BuildSpecificationNode>(){

            public boolean satisfied(BuildSpecificationNode t) {
                return t.getId() == id;
            }
        });
    }

    public BuildSpecificationNode getNodeByStageName(final String name) {
        return this.getNodeByPredicate(new Predicate<BuildSpecificationNode>(){

            public boolean satisfied(BuildSpecificationNode t) {
                return t.stage != null && name.equals(t.stage.getName());
            }
        });
    }

    public void removeChild(long id) {
        BuildSpecificationNode deadMan = null;
        for (BuildSpecificationNode child : this.children) {
            if (child.getId() != id) continue;
            deadMan = child;
            break;
        }
        if (deadMan != null) {
            this.children.remove((Object)deadMan);
        }
    }

    public List<ResourceRequirement> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void setResourceRequirements(List<ResourceRequirement> resourceRequirements) {
        this.resourceRequirements = resourceRequirements;
    }

    public void addResourceRequirement(ResourceRequirement resourceRequirement) {
        this.resourceRequirements.add(resourceRequirement);
    }

    public List<PostBuildAction> getPostActions() {
        return this.postActions;
    }

    private void setPostActions(List<PostBuildAction> postActions) {
        this.postActions = postActions;
    }

    public void addPostAction(PostBuildAction action) {
        this.postActions.add(action);
    }

    public void removePostAction(long id) {
        Iterator<PostBuildAction> it = this.postActions.iterator();
        while (it.hasNext()) {
            if (it.next().getId() != id) continue;
            it.remove();
            return;
        }
    }

    public PostBuildAction getPostAction(String name) {
        for (PostBuildAction p : this.postActions) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public PostBuildAction getPostAction(long id) {
        for (PostBuildAction a : this.postActions) {
            if (a.getId() != id) continue;
            return a;
        }
        return null;
    }
}

