/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.model.HistoryPage;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.User;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BuildManager {
    public void save(BuildResult var1);

    public void save(RecipeResultNode var1);

    public void save(RecipeResult var1);

    public void save(Changelist var1);

    public BuildResult getBuildResult(long var1);

    public RecipeResultNode getRecipeResultNode(long var1);

    public RecipeResultNode getResultNodeByResultId(long var1);

    public RecipeResult getRecipeResult(long var1);

    public CommandResult getCommandResult(long var1);

    public StoredArtifact getArtifact(long var1);

    public StoredFileArtifact getFileArtifact(long var1);

    public List<BuildResult> getPersonalBuilds(User var1);

    public BuildResult getLatestBuildResult(User var1);

    public BuildResult getLatestBuildResult();

    public List<BuildResult> queryBuilds(Project[] var1, ResultState[] var2, PersistentName[] var3, long var4, long var6, Boolean var8, int var9, int var10, boolean var11);

    public List<BuildResult> querySpecificationBuilds(Project var1, PersistentName var2, ResultState[] var3, long var4, long var6, int var8, int var9, boolean var10, boolean var11);

    public List<BuildResult> getLatestBuildResultsForProject(Project var1, int var2);

    public int getBuildCount(Project var1, ResultState[] var2, PersistentName var3);

    public void fillHistoryPage(HistoryPage var1);

    public void fillHistoryPage(HistoryPage var1, ResultState[] var2, PersistentName var3);

    public List<PersistentName> getBuildSpecifications(Project var1);

    public List<BuildResult> getLatestCompletedBuildResults(Project var1, PersistentName var2, int var3);

    public List<BuildResult> getLatestCompletedBuildResults(Project var1, PersistentName var2, int var3, int var4);

    public BuildResult getLatestBuildResult(Project var1);

    public BuildResult getLatestBuildResult(BuildSpecification var1);

    public BuildResult getLatestSuccessfulBuildResult(BuildSpecification var1);

    public BuildResult getLatestSuccessfulBuildResult(Project var1);

    public BuildResult getLatestSuccessfulBuildResult();

    public BuildResult getByProjectAndNumber(Project var1, long var2);

    public BuildResult getByUserAndNumber(User var1, long var2);

    public BuildResult getPreviousBuildResult(BuildResult var1);

    public void cleanupBuilds();

    public Revision getPreviousRevision(Project var1, PersistentName var2);

    public List<Changelist> getLatestChangesForUser(User var1, int var2);

    public List<Changelist> getLatestChangesForProject(Project var1, int var2);

    public List<Changelist> getLatestChangesForProjects(Project[] var1, int var2);

    public List<Changelist> getChangesForBuild(BuildResult var1);

    public void deleteAllBuilds(Project var1);

    public void deleteAllBuilds(User var1);

    public Changelist getChangelistByRevision(String var1, Revision var2);

    public void delete(BuildResult var1);

    public void abortUnfinishedBuilds(Project var1, String var2);

    public void abortUnfinishedBuilds(User var1, String var2);

    public boolean isSpaceAvailableForBuild();

    public boolean canCancel(BuildResult var1, User var2);

    public void cleanupBuilds(User var1);

    public void cleanupBuilds(Project var1);

    public void cleanupBuilds(CleanupRule var1);

    public boolean isCleanupInProgress(Project var1);

    public CommandResult getCommandResultByArtifact(long var1);

    public CommandResult getCommandResult(long var1, String var3);

    public StoredArtifact getArtifact(long var1, String var3);

    public StoredArtifact getCommandResultByArtifact(long var1, String var3);

    public Boolean canDecorateArtifact(long var1);

    public void executeInTransaction(Runnable var1);
}

