/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.model.GrantedAuthority;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.User;
import java.util.LinkedList;
import java.util.List;
import org.acegisecurity.userdetails.UserDetails;

public class AcegiUser
implements UserDetails {
    private User user;
    private List<String> transientAuthorities = new LinkedList<String>();

    public AcegiUser(User user) {
        this.user = user;
    }

    public org.acegisecurity.GrantedAuthority[] getAuthorities() {
        List<String> directAuthorities = this.user.getGrantedAuthorities();
        int total = directAuthorities.size() + this.transientAuthorities.size();
        for (Group g : this.user.getGroups()) {
            total += g.getAuthorityCount();
        }
        org.acegisecurity.GrantedAuthority[] result = new GrantedAuthority[total];
        int i = 0;
        for (String authority : directAuthorities) {
            result[i++] = new GrantedAuthority(authority);
        }
        for (String authority : this.transientAuthorities) {
            result[i++] = new GrantedAuthority(authority);
        }
        for (Group g : this.user.getGroups()) {
            for (GrantedAuthority authority : g.getAuthorities()) {
                result[i++] = authority;
            }
        }
        return result;
    }

    public boolean hasAuthority(String authority) {
        org.acegisecurity.GrantedAuthority[] authorities;
        for (org.acegisecurity.GrantedAuthority a : authorities = this.getAuthorities()) {
            if (!a.getAuthority().equals(authority)) continue;
            return true;
        }
        return false;
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getLogin();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void addTransientAuthority(String authority) {
        if (!this.transientAuthorities.contains(authority)) {
            this.transientAuthorities.add(authority);
        }
    }

    public User getUser() {
        return this.user;
    }
}

