/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license.authorisation;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseType;
import com.zutubi.pulse.license.authorisation.Authorisation;
import java.util.Date;

public class CanRunPulseAuthorisation
implements Authorisation {
    private static final String[] AUTH = new String[]{"canRunPulse"};

    public String[] getAuthorisation(License license) {
        return this.getAuthorisation(license, Version.getVersion());
    }

    public String[] getAuthorisation(License license, Version version) {
        if (license == null) {
            return NO_AUTH;
        }
        if (!license.isExpired()) {
            return AUTH;
        }
        if (LicenseType.EVALUATION == license.getType()) {
            return NO_AUTH;
        }
        Date vrd = version.getReleaseDateAsDate();
        Date expiry = license.getExpiryDate();
        if (vrd.getTime() < expiry.getTime()) {
            return AUTH;
        }
        return NO_AUTH;
    }
}

