/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license;

import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseExpiredEvent;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.license.LicenseManager;
import com.zutubi.pulse.scheduling.CronTrigger;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Task;
import com.zutubi.pulse.scheduling.TaskExecutionContext;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.util.logging.Logger;

public class LicenseMonitor
implements Task {
    private static final Logger LOG = Logger.getLogger(LicenseMonitor.class);
    private EventManager eventManager;
    private Scheduler scheduler;
    private LicenseManager licenseManager;

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void execute(TaskExecutionContext context) {
        License license = LicenseHolder.getLicense();
        if (license.isExpired()) {
            this.licenseManager.refreshAuthorisations();
            this.eventManager.publish((Event)new LicenseExpiredEvent(license));
        }
    }

    public void init() {
        Trigger trigger = this.scheduler.getTrigger("license", "monitor");
        if (trigger != null) {
            return;
        }
        trigger = new CronTrigger("0 0 1 * * ?", "license", "monitor");
        trigger.setTaskClass(LicenseMonitor.class);
        try {
            this.scheduler.schedule(trigger);
        }
        catch (SchedulingException e) {
            LOG.severe((Throwable)((Object)e));
        }
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

