/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.events.DataDirectoryChangedEvent;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseDecoder;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.license.LicenseKeyStore;
import com.zutubi.pulse.license.LicenseUpdateEvent;
import com.zutubi.pulse.license.authorisation.Authorisation;
import com.zutubi.pulse.license.authorisation.CanRunPulseAuthorisation;
import com.zutubi.pulse.util.logging.Logger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseManager {
    private static final Logger LOG = Logger.getLogger(LicenseManager.class);
    private EventManager eventManager;
    private LicenseKeyStore keyStore;
    private List<Authorisation> authorisations = new LinkedList<Authorisation>();

    public void installLicense(String newKey) throws LicenseException {
        LicenseDecoder decoder = new LicenseDecoder();
        License license = decoder.decode(newKey.getBytes());
        this.keyStore.setKey(newKey);
        LicenseHolder.setLicense(license);
        this.refreshAuthorisations();
        this.eventManager.publish((Event)new LicenseUpdateEvent(license));
    }

    public void init() {
        this.eventManager.register(new EventListener(){

            public void handleEvent(Event evt) {
                LicenseManager.this.refresh();
            }

            public Class[] getHandledEvents() {
                return new Class[]{DataDirectoryChangedEvent.class};
            }
        });
        this.refresh();
    }

    private void refresh() {
        String key = this.keyStore.getKey();
        if (key != null) {
            try {
                LicenseDecoder decoder = new LicenseDecoder();
                License license = decoder.decode(key.getBytes());
                LicenseHolder.setLicense(license);
            }
            catch (LicenseException e) {
                LOG.warning("Failed to decode the configured license key.", (Throwable)((Object)e));
                LicenseHolder.setLicense(null);
            }
        }
        this.refreshAuthorisations();
    }

    public void refreshAuthorisations() {
        License license = LicenseHolder.getLicense();
        LinkedList<String> newAuths = new LinkedList<String>();
        for (Authorisation auth : this.authorisations) {
            newAuths.addAll(Arrays.asList(auth.getAuthorisation(license)));
        }
        LicenseHolder.setAuthorizations(newAuths);
    }

    public boolean canRun(Version version) {
        CanRunPulseAuthorisation canRunPulse = new CanRunPulseAuthorisation();
        List<String> auths = Arrays.asList(canRunPulse.getAuthorisation(LicenseHolder.getLicense(), version));
        return auths.contains("canRunPulse");
    }

    public void setAuthorisations(List<Authorisation> a) {
        this.authorisations = a;
    }

    public void addAuthorisation(Authorisation auth) {
        this.authorisations.add(auth);
        this.refreshAuthorisations();
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setLicenseKeyStore(LicenseKeyStore keyStore) {
        this.keyStore = keyStore;
    }
}

