/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseType;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class LicenseDecoder {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final byte[] PUBLIC_RSA_KEY = "MIGeMA0GCSqGSIb3DQEBAQUAA4GMADCBiAKBgGOte/JJ03YV1QPa7cDwMd5oJEBz15iL1gQzU/QW9EaSxJtqrYf3DVKE+YOOGBoemnfxv2me6BZ2KQl4++xyw98Hou7uTu84qhdR+IU9jCp96sExUV6GGEmqBpcaPYVXIwb48/NndEhEktXIc4hpMXhWWxF1GbMb8bLf3umas4onAgMBAAE=".getBytes();

    public License decode(byte[] raw) throws LicenseException {
        byte[] data = Base64.decodeBase64((byte[])raw);
        if (data.length < 4) {
            return null;
        }
        int length = ((0xFF & data[0]) << 24) + ((0xFF & data[1]) << 16) + ((0xFF & data[2]) << 8) + (0xFF & data[3]);
        if (length < 0) {
            return null;
        }
        if (data.length < 4 + length) {
            return null;
        }
        byte[] licenseStr = new byte[length];
        System.arraycopy(data, 4, licenseStr, 0, licenseStr.length);
        byte[] sig = new byte[data.length - 4 - length];
        System.arraycopy(data, 4 + length, sig, 0, sig.length);
        if (!LicenseDecoder.verifySignature(licenseStr, sig)) {
            return null;
        }
        return this.fromString(new String(licenseStr));
    }

    private License fromString(String data) throws LicenseException {
        try {
            LicenseType type;
            LineNumberReader reader = new LineNumberReader(new StringReader(data));
            String code = reader.readLine();
            String holder = reader.readLine();
            String expiryString = reader.readLine();
            String agents = reader.readLine();
            String projects = reader.readLine();
            String users = reader.readLine();
            String contactPoints = reader.readLine();
            if (code != null && code.length() == 1) {
                code = this.mapCode(code);
            }
            if (!(TextUtils.stringSet((String)code) && TextUtils.stringSet((String)holder) && TextUtils.stringSet((String)expiryString))) {
                return null;
            }
            try {
                type = LicenseType.valueOf(code);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            Date expiryDate = null;
            if (!expiryString.equals("Never")) {
                expiryDate = DATE_FORMAT.parse(expiryString);
            }
            License license = new License(type, holder, expiryDate);
            license.setSupported(Integer.valueOf(agents), Integer.valueOf(projects), Integer.valueOf(users));
            if (contactPoints != null) {
                license.setSupportedContactPoints(Integer.valueOf(contactPoints));
            }
            return license;
        }
        catch (IOException e) {
            throw new LicenseException(e);
        }
        catch (ParseException e) {
            throw new LicenseException(e);
        }
    }

    private String mapCode(String code) {
        if (code.equals("e")) {
            return "EVALUATION";
        }
        return "CUSTOM";
    }

    private static boolean verifySignature(byte[] licData, byte[] signData) throws LicenseException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] rawPublicKey = Base64.decodeBase64((byte[])PUBLIC_RSA_KEY);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(rawPublicKey);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sign = Signature.getInstance("SHA1withRSA");
            sign.initVerify(publicKey);
            sign.update(licData);
            return sign.verify(signData);
        }
        catch (Exception e) {
            throw new LicenseException(e);
        }
    }
}

