/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license;

import com.zutubi.pulse.license.LicenseType;
import com.zutubi.pulse.util.ObjectUtils;
import java.util.Calendar;
import java.util.Date;

public class License {
    private LicenseType type;
    private String holder;
    private Date expiryDate;
    public static final int UNRESTRICTED = -1;
    public static final int UNSPECIFIED = -2;
    private int supportedProjects = -1;
    private int supportedUsers = -1;
    private int supportedAgents = -1;
    private int supportedContactPoints = -2;

    public License(LicenseType type, String holder) {
        this(type, holder, null);
    }

    public License(LicenseType type, String holder, Date expiry) {
        this.type = type;
        this.holder = holder;
        this.expiryDate = expiry;
    }

    public License setSupported(int agents, int projects, int users) {
        this.setSupportedAgents(agents);
        this.setSupportedProjects(projects);
        this.setSupportedUsers(users);
        return this;
    }

    public License setSupportedAgents(int agents) {
        this.supportedAgents = agents;
        return this;
    }

    public License setSupportedProjects(int projects) {
        this.supportedProjects = projects;
        return this;
    }

    public License setSupportedUsers(int users) {
        this.supportedUsers = users;
        return this;
    }

    public License setSupportedContactPoints(int contactPoints) {
        this.supportedContactPoints = contactPoints;
        return this;
    }

    public String getHolder() {
        return this.holder;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public LicenseType getType() {
        return this.type;
    }

    public int getSupportedProjects() {
        return this.supportedProjects;
    }

    public int getSupportedUsers() {
        return this.supportedUsers;
    }

    public int getSupportedAgents() {
        return this.supportedAgents;
    }

    public int getSupportedContactPoints() {
        if (this.supportedContactPoints == -2) {
            if (this.type == LicenseType.SMALL_TEAM) {
                return 3;
            }
            return -1;
        }
        return this.supportedContactPoints;
    }

    public boolean equals(Object o) {
        if (!(o instanceof License)) {
            return false;
        }
        License other = (License)o;
        return ObjectUtils.equals((Object)this.holder, (Object)other.holder) && ObjectUtils.equals((Object)this.expiryDate, (Object)other.expiryDate) && ObjectUtils.equals((Object)((Object)this.type), (Object)((Object)other.type)) && ObjectUtils.equals((Object)this.supportedAgents, (Object)other.supportedAgents) && ObjectUtils.equals((Object)this.supportedUsers, (Object)other.supportedUsers) && ObjectUtils.equals((Object)this.supportedContactPoints, (Object)other.supportedContactPoints) && ObjectUtils.equals((Object)this.supportedProjects, (Object)other.supportedProjects);
    }

    public boolean isExpired() {
        if (this.expires()) {
            return this.getDaysRemaining() == 0;
        }
        return false;
    }

    public boolean expires() {
        return this.getExpiryDate() != null;
    }

    public int getDaysRemaining() {
        if (this.expires()) {
            return License.calculateDaysRemaining(Calendar.getInstance().getTime(), this.getExpiryDate());
        }
        return -1;
    }

    static int calculateDaysRemaining(Date now, Date expiry) {
        Calendar x = Calendar.getInstance();
        x.setTime(expiry);
        x.add(6, 1);
        x.set(11, 0);
        x.set(12, 0);
        x.set(13, 0);
        x.set(14, 0);
        int daysRemaining = 0;
        long timeRemainingInMilliSeconds = x.getTimeInMillis() - now.getTime();
        if (timeRemainingInMilliSeconds > 0L) {
            daysRemaining = (int)(timeRemainingInMilliSeconds / 86400000L);
            if (timeRemainingInMilliSeconds % 86400000L > 0L) {
                ++daysRemaining;
            }
        }
        return daysRemaining;
    }
}

