/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.jetty;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.util.logging.Logger;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.springframework.beans.factory.FactoryBean;

public class JettyServerFactoryBean
implements FactoryBean {
    private static final Logger LOG = Logger.getLogger(JettyServerFactoryBean.class);
    private Server instance;
    private MasterConfigurationManager configManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        if (this.instance == null) {
            JettyServerFactoryBean jettyServerFactoryBean = this;
            synchronized (jettyServerFactoryBean) {
                if (this.instance == null) {
                    this.instance = new Server();
                    SocketListener listener = new SocketListener();
                    SystemConfiguration systemConfiguration = this.configManager.getSystemConfig();
                    listener.setHost(systemConfiguration.getBindAddress());
                    listener.setPort(systemConfiguration.getServerPort());
                    this.instance.addListener((HttpListener)listener);
                }
            }
        }
        return this.instance;
    }

    public Class getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfigurationManager(MasterConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public void shutdown() {
        try {
            if (this.instance.isStarted()) {
                this.instance.stop();
            }
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
    }
}

