/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.jabber;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.util.logging.Logger;
import org.jivesoftware.smack.GoogleTalkConnection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;

public class JabberManager
implements Stoppable,
PacketListener {
    public static final int DEFAULT_PORT = 5222;
    private static final Logger LOG = Logger.getLogger(JabberManager.class);
    private XMPPConnection connection = null;
    private MasterConfigurationManager configurationManager;
    private String statusMessage = null;
    private long lastFailureTime = -1L;

    public synchronized void init() {
        this.statusMessage = null;
        MasterConfiguration appConfig = this.configurationManager.getAppConfig();
        if (this.isConfigured()) {
            LOG.info("Initialising Jabber");
            Roster.setDefaultSubscriptionMode((int)0);
            try {
                this.openConnection(appConfig);
            }
            catch (Exception e) {
                LOG.warning("Retrying Jabber initialisation");
                try {
                    this.stop(true);
                    this.openConnection(appConfig);
                }
                catch (Exception nesty) {
                    this.connectionError("Could not initialise Jabber: " + nesty.getMessage());
                }
            }
        }
        if (this.connection != null) {
            LOG.info("Jabber initialised");
        }
    }

    public boolean isConfigured() {
        return TextUtils.stringSet((String)this.configurationManager.getAppConfig().getJabberHost());
    }

    private void openConnection(MasterConfiguration appConfig) throws XMPPException {
        this.connection = this.openConnection(appConfig.getJabberHost(), appConfig.getJabberPort(), appConfig.getJabberUsername(), appConfig.getJabberPassword(), appConfig.getJabberForceSSL());
        this.connection.addPacketListener((PacketListener)this, (PacketFilter)new MessageTypeFilter(Message.Type.ERROR));
    }

    private XMPPConnection openConnection(String host, int port, String username, String password, boolean forceSSL) throws XMPPException {
        Object connection = null;
        connection = host.endsWith("google.com") ? new GoogleTalkConnection() : (forceSSL ? new SSLXMPPConnection(host, port) : new XMPPConnection(host, port));
        connection.login(username, password);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(String host, int port, String username, String password, boolean forceSSL) throws XMPPException {
        XMPPConnection connection = null;
        try {
            try {
                connection = this.openConnection(host, port, username, password, forceSSL);
            }
            catch (XMPPException e) {
                connection = this.openConnection(host, port, username, password, forceSSL);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public XMPPConnection getConnection() {
        if (this.connection == null && (this.lastFailureTime < 0L || this.lastFailureTime + 60000L < System.currentTimeMillis())) {
            this.init();
        }
        return this.connection;
    }

    public void connectionError(String message) {
        this.stop(true);
        this.statusMessage = message;
        this.lastFailureTime = System.currentTimeMillis();
        LOG.warning(this.statusMessage);
    }

    public synchronized void stop(boolean force) {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void processPacket(Packet packet) {
        XMPPError error = packet.getError();
        if (error != null) {
            String message = "Jabber error";
            if (packet.getFrom() != null) {
                message = message + ": from " + packet.getFrom();
            }
            message = message + ": code " + error.getCode();
            if (error.getMessage() != null) {
                message = message + ": " + error.getMessage();
            }
            LOG.error(message);
        }
    }

    public void refresh() {
        this.stop(true);
        this.init();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

