/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.ui.components;

import com.zutubi.pulse.form.ui.RenderContext;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component {
    protected RenderContext context;
    protected Map<String, Object> parameters;
    private Component parent;
    private List<Component> nestedComponents;

    public void setContext(RenderContext context) {
        this.context = context;
    }

    public boolean start() throws Exception {
        return true;
    }

    public boolean end() throws Exception {
        return false;
    }

    public List<Component> getNestedComponents() {
        if (this.nestedComponents == null) {
            this.nestedComponents = new LinkedList<Component>();
        }
        return this.nestedComponents;
    }

    public void addNestedComponent(Component component) {
        component.parent = this;
        this.getNestedComponents().add(component);
    }

    protected Map<String, Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        return this.parameters;
    }

    public void addParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    public void addParameters(Map<String, Object> params) {
        this.getParameters().putAll(params);
    }

    public Component getNestedComponent(String id) {
        if (id == null) {
            return null;
        }
        for (Component component : this.getNestedComponents()) {
            if (!id.equals(component.getId())) continue;
            return component;
        }
        return null;
    }

    protected Component findAncestor(Class clazz) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getClass() == clazz) {
            return this.parent;
        }
        return this.parent.findAncestor(clazz);
    }

    public String getId() {
        return (String)this.getParameters().get("id");
    }

    public void setId(String id) {
        this.addParameter("id", id);
    }

    protected String getText(String key) {
        String str = this.context.getText(key);
        if (str != null) {
            return str;
        }
        return key;
    }
}

