/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.ui;

import com.zutubi.pulse.form.descriptor.ActionDescriptor;
import com.zutubi.pulse.form.descriptor.FieldDescriptor;
import com.zutubi.pulse.form.descriptor.FormDescriptor;
import com.zutubi.pulse.form.ui.components.CheckboxField;
import com.zutubi.pulse.form.ui.components.Form;
import com.zutubi.pulse.form.ui.components.HiddenField;
import com.zutubi.pulse.form.ui.components.PasswordField;
import com.zutubi.pulse.form.ui.components.RadioField;
import com.zutubi.pulse.form.ui.components.SelectField;
import com.zutubi.pulse.form.ui.components.Submit;
import com.zutubi.pulse.form.ui.components.SubmitGroup;
import com.zutubi.pulse.form.ui.components.TextField;
import com.zutubi.pulse.form.ui.components.UIComponent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormFactory {
    public Form createForm(FormDescriptor descriptor, Object instance) {
        List<String> fieldOrder = this.evaluateFieldOrder(descriptor);
        Form form = new Form();
        form.setId(instance.getClass().getSimpleName());
        form.setMethod("post");
        form.addParameters(descriptor.getParameters());
        int i = 1;
        for (String fieldName : fieldOrder) {
            UIComponent field = this.createField(descriptor.getFieldDescriptor(fieldName), instance);
            field.setTabindex(i++);
            form.addNestedComponent(field);
        }
        SubmitGroup submitGroup = new SubmitGroup();
        for (ActionDescriptor actionDescriptor : descriptor.getActionDescriptors()) {
            Submit field = new Submit();
            field.setName(actionDescriptor.getAction());
            field.setValue(actionDescriptor.getAction() + ".label");
            field.setTabindex(i++);
            submitGroup.addNestedComponent(field);
        }
        form.addNestedComponent(submitGroup);
        return form;
    }

    protected List<String> evaluateFieldOrder(FormDescriptor descriptor) {
        LinkedList<String> ordered = new LinkedList<String>();
        if (descriptor.getFieldOrder() != null) {
            ordered.addAll(Arrays.asList(descriptor.getFieldOrder()));
        }
        if (ordered.size() == descriptor.getFieldDescriptors().size()) {
            return ordered;
        }
        for (FieldDescriptor fd : descriptor.getFieldDescriptors()) {
            if (ordered.contains(fd.getName())) continue;
            ordered.addLast(fd.getName());
        }
        return ordered;
    }

    protected UIComponent createField(FieldDescriptor descriptor, Object instance) {
        if ("text".equals(descriptor.getFieldType())) {
            return this.createTextField(descriptor);
        }
        if ("password".equals(descriptor.getFieldType())) {
            return this.createPasswordField(descriptor);
        }
        if ("radio".equals(descriptor.getFieldType())) {
            return this.createRadioField(descriptor);
        }
        if ("select".equals(descriptor.getFieldType())) {
            return this.createSelectField(descriptor, instance);
        }
        if ("checkbox".equals(descriptor.getFieldType())) {
            return this.createCheckboxField(descriptor);
        }
        if ("hidden".equals(descriptor.getFieldType())) {
            return this.createHiddenField(descriptor);
        }
        throw new RuntimeException("Unsupported field type '" + descriptor.getFieldType() + "'");
    }

    private UIComponent createCheckboxField(FieldDescriptor descriptor) {
        CheckboxField c = new CheckboxField();
        this.configureComponent(c, descriptor);
        return c;
    }

    private UIComponent createHiddenField(FieldDescriptor descriptor) {
        HiddenField c = new HiddenField();
        this.configureComponent(c, descriptor);
        return c;
    }

    private UIComponent createSelectField(FieldDescriptor descriptor, Object instance) {
        SelectField c = new SelectField();
        this.configureComponent(c, descriptor);
        String name = descriptor.getName();
        String optionMethodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1) + "Options";
        try {
            Method optionMethod = instance.getClass().getMethod(optionMethodName, new Class[0]);
            Collection list = (Collection)optionMethod.invoke(instance, new Object[0]);
            c.setList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    private UIComponent createRadioField(FieldDescriptor descriptor) {
        RadioField c = new RadioField();
        this.configureComponent(c, descriptor);
        return c;
    }

    private UIComponent createPasswordField(FieldDescriptor descriptor) {
        PasswordField c = new PasswordField();
        this.configureComponent(c, descriptor);
        return c;
    }

    private UIComponent createTextField(FieldDescriptor descriptor) {
        TextField c = new TextField();
        this.configureComponent(c, descriptor);
        return c;
    }

    private void configureComponent(UIComponent c, FieldDescriptor descriptor) {
        c.setName(descriptor.getName());
        c.setId(descriptor.getName());
        c.setLabel(descriptor.getName() + ".label");
        c.setRequired(descriptor.isRequired());
        Map<String, Object> parameters = descriptor.getParameters();
        c.addParameters(parameters);
    }
}

