/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.persist.file;

import com.zutubi.pulse.form.persist.PersistenceException;
import com.zutubi.pulse.form.persist.file.FileKeyGenerator;
import com.zutubi.pulse.test.PulseTestCase;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FileKeyGeneratorTest
extends PulseTestCase {
    private FileKeyGenerator keyGenerator;
    private File tmpDir;

    protected void setUp() throws Exception {
        super.setUp();
        this.tmpDir = FileSystemUtils.createTempDir((String)FileKeyGenerator.class.getName(), (String)"tmp");
        this.keyGenerator = new FileKeyGenerator(this.tmpDir);
    }

    protected void tearDown() throws Exception {
        this.keyGenerator = null;
        this.removeDirectory(this.tmpDir);
        super.tearDown();
    }

    public void testKeyGenerationIsSequentialWithOutGaps() throws PersistenceException {
        for (long j = 1L; j < 1011L; ++j) {
            FileKeyGeneratorTest.assertEquals((Object)j, (Object)this.keyGenerator.generate(String.class));
        }
    }

    public void testDistinctObjectsHaveDistinctKeys() throws PersistenceException {
        FileKeyGeneratorTest.assertEquals((Object)1L, (Object)this.keyGenerator.generate(String.class));
        FileKeyGeneratorTest.assertEquals((Object)2L, (Object)this.keyGenerator.generate(String.class));
        FileKeyGeneratorTest.assertEquals((Object)1L, (Object)this.keyGenerator.generate(Object.class));
        FileKeyGeneratorTest.assertEquals((Object)2L, (Object)this.keyGenerator.generate(Object.class));
        FileKeyGeneratorTest.assertEquals((Object)3L, (Object)this.keyGenerator.generate(Object.class));
        FileKeyGeneratorTest.assertEquals((Object)3L, (Object)this.keyGenerator.generate(String.class));
    }

    public void testThatKeysAreStoredInFile() throws PersistenceException, IOException {
        FileKeyGeneratorTest.assertEquals((Object)1L, (Object)this.keyGenerator.generate(String.class));
        FileKeyGeneratorTest.assertEquals((Object)1L, (Object)this.keyGenerator.generate(Object.class));
        Properties props = IOUtils.read((File)new File(this.tmpDir, "keys.properties"));
        FileKeyGeneratorTest.assertEquals((String)"20", (String)props.getProperty("java.lang.String"));
        FileKeyGeneratorTest.assertEquals((String)"20", (String)props.getProperty("java.lang.Object"));
        FileKeyGeneratorTest.assertFalse((boolean)props.containsKey(Long.class));
    }

    public void testGeneratorAcrossRestart() throws PersistenceException {
        FileKeyGeneratorTest.assertEquals((Object)1L, (Object)this.keyGenerator.generate(String.class));
        this.keyGenerator = new FileKeyGenerator(this.tmpDir);
        FileKeyGeneratorTest.assertEquals((Object)21L, (Object)this.keyGenerator.generate(String.class));
    }
}

