/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.persist.file;

import com.zutubi.pulse.form.persist.KeyGenerator;
import com.zutubi.pulse.form.persist.PersistenceException;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileKeyGenerator
implements KeyGenerator {
    private static final int PRE_ALLOCATION_SIZE = 20;
    private static final String KEY_FILENAME = "keys.properties";
    private File dir = null;
    private File keyFile = null;
    private Map<Class, List<Serializable>> keyCache = new HashMap<Class, List<Serializable>>();

    public FileKeyGenerator(File dir) {
        this.dir = dir;
    }

    public void setBaseDir(File dir) {
        this.dir = dir;
    }

    public synchronized Serializable generate(Class clazz) throws PersistenceException {
        if (!this.keyCache.containsKey(clazz) || this.keyCache.get(clazz).size() == 0) {
            this.allocateKeys(clazz);
        }
        List<Serializable> cachedKeys = this.keyCache.get(clazz);
        return cachedKeys.remove(0);
    }

    private void allocateKeys(Class type) throws PersistenceException {
        if (!this.keyCache.containsKey(type)) {
            this.keyCache.put(type, new LinkedList());
        }
        List<Serializable> keys = this.keyCache.get(type);
        String keyName = type.getName();
        Properties props = this.loadFromFile();
        long start = Long.valueOf(props.getProperty(keyName, "0"));
        long finish = start + 20L;
        props.put(keyName, Long.toString(finish));
        this.saveToFile(props);
        for (long i = start + 1L; i <= finish; ++i) {
            keys.add(Long.valueOf(i));
        }
    }

    private void saveToFile(Properties props) throws PersistenceException {
        try {
            IOUtils.write((Properties)props, (File)this.keyFile());
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private Properties loadFromFile() throws PersistenceException {
        try {
            return IOUtils.read((File)this.keyFile());
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private File keyFile() throws PersistenceException {
        if (this.keyFile == null) {
            this.keyFile = new File(this.dir, KEY_FILENAME);
            if (!this.keyFile.exists()) {
                try {
                    File parent = this.keyFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException();
                    }
                    this.keyFile.createNewFile();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        return this.keyFile;
    }
}

