/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.descriptor.annotation;

import com.zutubi.pulse.form.descriptor.DescriptorDecorator;
import com.zutubi.pulse.form.descriptor.FieldDescriptor;
import com.zutubi.pulse.form.descriptor.FormDescriptor;
import com.zutubi.pulse.form.descriptor.annotation.Field;
import com.zutubi.pulse.form.descriptor.annotation.Form;
import com.zutubi.validation.annotations.Required;
import com.zutubi.validation.bean.AnnotationUtils;
import com.zutubi.validation.bean.BeanException;
import com.zutubi.validation.bean.BeanUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDecorator
implements DescriptorDecorator {
    @Override
    public FormDescriptor decorate(FormDescriptor descriptor) {
        Annotation[] classAnnotations = descriptor.getType().getAnnotations();
        this.decorateFromAnnotations(descriptor, classAnnotations);
        for (FieldDescriptor fieldDescriptor : descriptor.getFieldDescriptors()) {
            String fieldName = fieldDescriptor.getName();
            List<Annotation> fieldAnnotations = this.annotationsFromField(fieldName, descriptor.getType());
            this.decorateFromAnnotations(fieldDescriptor, fieldAnnotations);
        }
        return descriptor;
    }

    private List<Annotation> annotationsFromField(String fieldName, Class type) {
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        try {
            Method writeMethod;
            PropertyDescriptor property = BeanUtils.getPropertyDescriptor((String)fieldName, (Class)type);
            Method readMethod = property.getReadMethod();
            if (readMethod != null) {
                annotations.addAll(Arrays.asList(readMethod.getAnnotations()));
            }
            if ((writeMethod = property.getWriteMethod()) != null) {
                annotations.addAll(Arrays.asList(writeMethod.getAnnotations()));
            }
        }
        catch (BeanException e) {
            // empty catch block
        }
        return annotations;
    }

    private void decorateFromAnnotations(FormDescriptor descriptor, Annotation[] classAnnotations) {
        for (Annotation annotation : classAnnotations) {
            if (!(annotation instanceof Form)) continue;
            AnnotationUtils.setPropertiesFromAnnotation((Annotation)annotation, (Object)descriptor);
        }
    }

    private void decorateFromAnnotations(FieldDescriptor fieldDescriptor, List<Annotation> fieldAnnotations) {
        for (Annotation annotation : fieldAnnotations) {
            if (annotation instanceof Field) {
                this.handleFieldAnnotation((Field)annotation, fieldDescriptor);
            }
            if (annotation.annotationType().isAnnotationPresent(Field.class)) {
                Field fieldAnnotation = annotation.annotationType().getAnnotation(Field.class);
                this.handleFieldAnnotation(fieldAnnotation, fieldDescriptor);
                fieldDescriptor.getParameters().putAll(AnnotationUtils.collectPropertiesFromAnnotation((Annotation)annotation));
            }
            if (!(annotation instanceof Required)) continue;
            fieldDescriptor.setRequired(true);
        }
    }

    private void handleFieldAnnotation(Field annotation, FieldDescriptor descriptor) {
        descriptor.setFieldType(annotation.fieldType());
    }
}

