/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.condition;

import com.zutubi.pulse.condition.ChangedByMeNotifyCondition;
import com.zutubi.pulse.condition.ChangedNotifyCondition;
import com.zutubi.pulse.condition.ErrorNotifyCondition;
import com.zutubi.pulse.condition.FailureNotifyCondition;
import com.zutubi.pulse.condition.FalseNotifyCondition;
import com.zutubi.pulse.condition.NotifyCondition;
import com.zutubi.pulse.condition.StateChangeNotifyCondition;
import com.zutubi.pulse.condition.SuccessNotifyCondition;
import com.zutubi.pulse.condition.TrueNotifyCondition;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.core.PulseRuntimeException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyConditionFactory {
    public static final String CHANGED = "changed";
    public static final String CHANGED_BY_ME = "changed.by.me";
    public static final String ERROR = "error";
    public static final String FAILURE = "failure";
    public static final String FALSE = "false";
    public static final String SUCCESS = "success";
    public static final String STATE_CHANGE = "state.change";
    public static final String TRUE = "true";
    private static final Map<String, Class> typeMap = new HashMap<String, Class>();
    private ObjectFactory objectFactory;

    public List<String> getAvailableConditions() {
        return new LinkedList<String>(typeMap.keySet());
    }

    public boolean isValid(String key) {
        return typeMap.containsKey(key);
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public NotifyCondition createCondition(String condition) {
        if (!this.isValid(condition)) {
            throw new IllegalArgumentException("invalid condition '" + condition + "' specified.");
        }
        Class definition = typeMap.get(condition);
        try {
            return (NotifyCondition)this.objectFactory.buildBean(definition);
        }
        catch (Exception e) {
            throw new PulseRuntimeException((Throwable)e);
        }
    }

    static {
        typeMap.put(CHANGED, ChangedNotifyCondition.class);
        typeMap.put(CHANGED_BY_ME, ChangedByMeNotifyCondition.class);
        typeMap.put(ERROR, ErrorNotifyCondition.class);
        typeMap.put(FAILURE, FailureNotifyCondition.class);
        typeMap.put(FALSE, FalseNotifyCondition.class);
        typeMap.put(SUCCESS, SuccessNotifyCondition.class);
        typeMap.put(STATE_CHANGE, StateChangeNotifyCondition.class);
        typeMap.put(TRUE, TrueNotifyCondition.class);
    }
}

