/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.committransformers;

import com.opensymphony.util.TextUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommitMessageBuilder {
    private String message;
    private LinkedList<Boolean> mods;
    private LinkedList<Boolean> visible;

    public CommitMessageBuilder(String message) {
        this.message = message;
        this.mods = new LinkedList();
        for (int i = 0; i < message.length(); ++i) {
            this.mods.add(false);
        }
    }

    public String toString() {
        return this.message;
    }

    public String replace(String regex, String replacement) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(this.message);
        StringBuilder modifiedMessage = new StringBuilder();
        LinkedList modifiedMods = new LinkedList();
        int end = 0;
        while (matcher.find()) {
            int start = matcher.start();
            modifiedMessage.append(this.message.substring(end, start));
            modifiedMods.addAll(this.mods.subList(end, start));
            String replacementStr = this.processSubstitution(replacement, matcher);
            modifiedMessage.append(replacementStr);
            for (int i = 0; i < replacementStr.length(); ++i) {
                modifiedMods.add(true);
            }
            end = matcher.end();
        }
        if (end < this.message.length()) {
            String tail = this.message.substring(end);
            modifiedMessage.append(tail);
            modifiedMods.addAll(this.mods.subList(end, this.mods.size()));
        }
        this.message = modifiedMessage.toString();
        this.mods = modifiedMods;
        return this.toString();
    }

    public String encode() {
        StringBuilder modifiedMessage = new StringBuilder();
        LinkedList<Boolean> modifiedMods = new LinkedList<Boolean>();
        for (int i = 0; i < this.message.length(); ++i) {
            if (this.mods.get(i).booleanValue()) {
                modifiedMessage.append(this.message.charAt(i));
                modifiedMods.add(this.mods.get(i));
                continue;
            }
            String replacementStr = TextUtils.htmlEncode((String)("" + this.message.charAt(i)));
            modifiedMessage.append(replacementStr);
            for (int j = 0; j < replacementStr.length(); ++j) {
                modifiedMods.add(false);
            }
        }
        this.message = modifiedMessage.toString();
        this.mods = modifiedMods;
        return this.toString();
    }

    public String trim(int length) {
        int i;
        this.recalculateVisibleIndicies();
        String s = this.message;
        if (length == 0) {
            return "";
        }
        if (this.visibleLength() <= length) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < s.length(); ++i) {
            if (this.visible.get(i).booleanValue()) {
                if (result.length() < length) {
                    result.append(s.charAt(i));
                }
                if (result.length() != length) continue;
                break;
            }
            result.append(s.charAt(i));
            ++length;
        }
        if (this.mods.get(i).booleanValue()) {
            int j;
            for (j = i; 0 <= j && this.mods.get(j).booleanValue(); --j) {
            }
            String balanced = this.balanceTags(this.message.substring(++j, i + 1));
            result.replace(j, i + 1, balanced);
        }
        int count = 0;
        while (0 <= i && count < 3) {
            if (this.visible.get(i).booleanValue()) {
                ++count;
                result.setCharAt(i, '.');
            }
            --i;
        }
        this.message = result.toString();
        this.mods = new LinkedList(this.mods.subList(0, this.message.length()));
        return this.toString();
    }

    public String wrap(int lineLength) {
        this.recalculateVisibleIndicies();
        int splitOption = -1;
        int currentLineLength = 0;
        int lineStart = 0;
        StringBuilder modifiedMessage = new StringBuilder();
        for (int i = 0; i < this.message.length(); ++i) {
            if (!this.visible.get(i).booleanValue()) continue;
            char c = this.message.charAt(i);
            if (Character.isWhitespace(c)) {
                splitOption = i;
            }
            if (lineLength >= ++currentLineLength || splitOption == -1) continue;
            modifiedMessage.append(this.message.substring(lineStart, splitOption));
            modifiedMessage.append("\n");
            lineStart = splitOption + 1;
            splitOption = -1;
            currentLineLength = 0;
        }
        if (lineStart < this.message.length()) {
            modifiedMessage.append(this.message.substring(lineStart));
        }
        this.message = modifiedMessage.toString();
        return this.message;
    }

    public int getLength() {
        this.recalculateVisibleIndicies();
        return this.visibleLength();
    }

    private int visibleLength() {
        int i = 0;
        Iterator i$ = this.visible.iterator();
        while (i$.hasNext()) {
            boolean b = (Boolean)i$.next();
            if (!b) continue;
            ++i;
        }
        return i;
    }

    private void recalculateVisibleIndicies() {
        this.visible = new LinkedList();
        boolean isTag = false;
        for (int i = 0; i < this.message.length(); ++i) {
            char c = this.message.charAt(i);
            if (this.mods.get(i).booleanValue()) {
                if (c == '<' && !isTag) {
                    isTag = true;
                }
                this.visible.add(!isTag);
                if (c != '>' || !isTag) continue;
                isTag = false;
                continue;
            }
            isTag = false;
            this.visible.add(true);
        }
    }

    private String processSubstitution(String replacement, Matcher matcher) {
        int cursor = 0;
        StringBuilder result = new StringBuilder();
        while (cursor < replacement.length()) {
            char nextChar = replacement.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = replacement.charAt(++cursor);
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (matcher.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (matcher.group(refNum) == null) continue;
                result.append(matcher.group(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        return result.toString();
    }

    private String balanceTags(String html) {
        StringBuffer buffer = new StringBuffer(html.length());
        boolean isTag = false;
        StringBuffer tag = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < html.length(); ++i) {
            char c = html.charAt(i);
            if (c == '<' && !isTag) {
                isTag = true;
            }
            if (isTag) {
                tag.append(c);
            }
            buffer.append(c);
            if (c != '>' || !isTag) continue;
            isTag = false;
            if (tag.charAt(1) == '/') {
                stack.pop();
            } else {
                stack.push(tag.toString());
            }
            tag = new StringBuffer();
        }
        while (stack.size() > 0) {
            buffer.append(this.toClosingTag((String)stack.pop()));
        }
        return buffer.toString();
    }

    private String toClosingTag(String tag) {
        StringBuffer name = new StringBuffer();
        for (char c : tag.toCharArray()) {
            if (c == '<') continue;
            if (Character.isWhitespace(c) && name.length() > 0 || c == '>') break;
            name.append(c);
        }
        name.append(">");
        name.insert(0, "</");
        return name.toString();
    }
}

