/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.AdminCommand;
import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.command.HelpCommand;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPasswordCommand
extends AdminCommand {
    private String user;
    private String password;

    public void setUser(String username) {
        this.user = username;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public String getHelp() {
        return "reset a user's password";
    }

    public String getDetailedHelp() {
        return "Used to reset a user's password, typically because the user has forgotten\ntheir current password.";
    }

    public List<String> getUsages() {
        return Arrays.asList("<username> <password>");
    }

    public List<String> getAliases() {
        return Arrays.asList("passwd", "password", "sp", "setp");
    }

    public int doExecute(BootContext context) throws XmlRpcException, IOException, ParseException {
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(this.getSharedOptions(), context.getCommandArgv(), true);
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            HelpCommand helpCommand = new HelpCommand();
            helpCommand.showHelp(context.getArgv()[0], (Command)this);
            return 1;
        }
        this.setUser(args[0]);
        this.setPassword(args[1]);
        this.xmlRpcClient.execute("RemoteApi.setPassword", new Vector<Object>(Arrays.asList(this.adminToken, this.user, this.password)));
        return 0;
    }

    public static void main(String[] argv) {
        SetPasswordCommand command = new SetPasswordCommand();
        try {
            command.execute(new BootContext(null, argv, null, null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

