/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.Chart;
import com.zutubi.pulse.charting.ChartColours;
import com.zutubi.pulse.charting.DailyData;
import com.zutubi.pulse.charting.DailyDataHandler;
import com.zutubi.pulse.charting.TimeBasedChartData;
import com.zutubi.pulse.i18n.Messages;
import java.awt.Color;
import java.awt.Paint;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class TestCountChart
implements XYToolTipGenerator,
Chart {
    private static final Messages I18N = Messages.getInstance(TestCountChart.class);
    private TimeBasedChartData data;
    private String domainAxisLabel = "axis.domain.label";
    private String rangeAxisLabel = "axis.range.label";
    private String chartLabel = "chart.label";
    private String seriesTimeLabel = "series.time.label";
    private String seriesTimeTooltip = "series.time.tooltip";

    public String generateToolTip(XYDataset dataset, int series, int item) {
        return String.format(I18N.format(this.seriesTimeTooltip), dataset.getY(series, item));
    }

    public JFreeChart render() {
        final TimeTableXYDataset ds = new TimeTableXYDataset();
        final double[] minCount = new double[]{Double.MAX_VALUE};
        final double[] maxCount = new double[]{Double.MIN_VALUE};
        this.data.populateDataSet(ds, new DailyDataHandler(){

            public void handle(Date day, DailyData data) {
                if (data != null && data.getSuccessCount() > 0) {
                    double testCount = data.getAverageTestCount();
                    ds.add((TimePeriod)new Day(day), testCount, I18N.format(TestCountChart.this.seriesTimeLabel));
                    minCount[0] = Math.min(minCount[0], testCount);
                    maxCount[0] = Math.max(maxCount[0], testCount);
                }
            }
        });
        DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
        renderer.setToolTipGenerator((XYToolTipGenerator)this);
        DateAxis domainAxis = new DateAxis(I18N.format(this.domainAxisLabel));
        domainAxis.setLowerBound(this.data.getLowerBound());
        domainAxis.setUpperBound(this.data.getUpperBound());
        if (minCount[0] == Double.MAX_VALUE && maxCount[0] == Double.MIN_VALUE) {
            minCount[0] = 5.0;
            maxCount[0] = 100.0;
        }
        NumberAxis rangeAxis = new NumberAxis(I18N.format(this.rangeAxisLabel));
        double buffer = Math.max(maxCount[0] / 15.0, 5.0);
        rangeAxis.setLowerBound(Math.max(minCount[0] - buffer, 0.0));
        rangeAxis.setUpperBound(maxCount[0] + buffer);
        XYPlot plot = new XYPlot((XYDataset)ds, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(I18N.format(this.chartLabel), (Plot)plot);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)ChartColours.NEUTRAL);
        return chart;
    }

    public void setData(TimeBasedChartData data) {
        this.data = data;
    }
}

