/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.BuildResultsDataSource;
import com.zutubi.pulse.charting.BuildResultsResultSet;
import com.zutubi.pulse.model.BuildResult;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoBuildResultDataSource
implements BuildResultsDataSource {
    private List<BuildResult> data;

    public DemoBuildResultDataSource(List<BuildResult> data) {
        this.data = data;
    }

    @Override
    public BuildResultsResultSet getLastByBuilds(int builds) {
        if (builds >= this.data.size()) {
            return new BuildResultsResultSet(this.data);
        }
        return new BuildResultsResultSet(this.data.subList(this.data.size() - builds, this.data.size() - 1));
    }

    @Override
    public BuildResultsResultSet getLastByDays(int days) {
        Calendar start = Calendar.getInstance();
        start.add(6, -days);
        long starttime = start.getTimeInMillis();
        LinkedList<BuildResult> results = new LinkedList<BuildResult>();
        for (BuildResult result : this.data) {
            if (result.getStamps().getEndTime() <= starttime) continue;
            results.add(result);
        }
        return new BuildResultsResultSet(results);
    }
}

