/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.BuildResultsDataSource;
import com.zutubi.pulse.charting.BuildResultsResultSet;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.persistence.BuildResultDao;
import java.util.Calendar;
import java.util.List;

public class DBBuildResultsDataSource
implements BuildResultsDataSource {
    private BuildResultDao buildResultDao;
    private Project project;
    private BuildSpecification spec;

    public void setProject(Project project) {
        this.project = project;
    }

    public void setSpec(BuildSpecification spec) {
        this.spec = spec;
    }

    public BuildResultsResultSet getLastByBuilds(int builds) {
        List<BuildResult> results = this.buildResultDao.findLatestCompleted(this.project, this.spec.getPname(), 0, builds);
        return new BuildResultsResultSet(results);
    }

    public BuildResultsResultSet getLastByDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -days);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        List<BuildResult> results = this.buildResultDao.findSinceByProject(this.project, this.spec.getPname(), cal.getTime());
        return new BuildResultsResultSet(results);
    }

    public void setBuildResultDao(BuildResultDao buildResultDao) {
        this.buildResultDao = buildResultDao;
    }
}

