/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.Chart;
import com.zutubi.pulse.charting.ChartColours;
import com.zutubi.pulse.charting.DailyData;
import com.zutubi.pulse.charting.DailyDataHandler;
import com.zutubi.pulse.charting.TimeBasedChartData;
import com.zutubi.pulse.i18n.Messages;
import java.awt.Color;
import java.awt.Paint;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class BuildTimesChart
implements XYToolTipGenerator,
Chart {
    private static final Messages I18N = Messages.getInstance(BuildTimesChart.class);
    private boolean stages;
    private TimeBasedChartData data;
    private String domainAxisLabel = "axis.domain.label";
    private String rangeAxisLabel = "axis.range.label";
    private String chartLabel = "chart.label";
    private String seriesTimeLabel = "series.time.label";
    private String seriesTimeTooltip = "series.time.tooltip";

    public BuildTimesChart(boolean stages) {
        this.stages = stages;
        if (stages) {
            this.chartLabel = this.chartLabel + ".stages";
        }
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        return String.format(I18N.format(this.seriesTimeTooltip), dataset.getY(series, item));
    }

    public JFreeChart render() {
        final TimeTableXYDataset ds = new TimeTableXYDataset();
        final double[] minTime = new double[]{Double.MAX_VALUE};
        final double[] maxTime = new double[]{Double.MIN_VALUE};
        this.data.populateDataSet(ds, new DailyDataHandler(){

            public void handle(Date day, DailyData data) {
                if (data != null && data.getSuccessCount() > 0) {
                    double elapsed = BuildTimesChart.this.stages ? data.getAverageStageTime() : data.getAverageBuildTime();
                    ds.add((TimePeriod)new Day(day), elapsed, I18N.format(BuildTimesChart.this.seriesTimeLabel));
                    minTime[0] = Math.min(minTime[0], elapsed);
                    maxTime[0] = Math.max(maxTime[0], elapsed);
                }
            }
        });
        DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
        renderer.setToolTipGenerator((XYToolTipGenerator)this);
        DateAxis domainAxis = new DateAxis(I18N.format(this.domainAxisLabel));
        domainAxis.setLowerBound(this.data.getLowerBound());
        domainAxis.setUpperBound(this.data.getUpperBound());
        if (minTime[0] == Double.MAX_VALUE && maxTime[0] == Double.MIN_VALUE) {
            minTime[0] = 5.0;
            maxTime[0] = 100.0;
        }
        NumberAxis rangeAxis = new NumberAxis(I18N.format(this.rangeAxisLabel));
        double buffer = Math.max(maxTime[0] / 15.0, 5.0);
        rangeAxis.setLowerBound(Math.max(minTime[0] - buffer, 0.0));
        rangeAxis.setUpperBound(maxTime[0] + buffer);
        XYPlot plot = new XYPlot((XYDataset)ds, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(I18N.format(this.chartLabel), (Plot)plot);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)ChartColours.NEUTRAL);
        return chart;
    }

    public void setData(TimeBasedChartData data) {
        this.data = data;
    }
}

