/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.charting;

import com.zutubi.pulse.charting.ResultSet;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultsResultSet
implements ResultSet {
    private Iterator<BuildResult> results;
    private List<BuildResult> source;
    private Object current;

    public BuildResultsResultSet(List<BuildResult> source) {
        this.source = source;
        this.results = this.source.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.results.hasNext();
    }

    @Override
    public boolean next() {
        if (this.results.hasNext()) {
            this.current = this.results.next();
            return true;
        }
        return false;
    }

    public long getEndTime() {
        return ((BuildResult)this.current).getStamps().getEndTime();
    }

    public ResultState getState() {
        return ((BuildResult)this.current).getState();
    }

    public long getId() {
        return ((BuildResult)this.current).getId();
    }

    public long getNumber() {
        return ((BuildResult)this.current).getNumber();
    }

    public long getElapsed() {
        return ((BuildResult)this.current).getStamps().getElapsed();
    }

    public double getAverageStageTime() {
        int count = 0;
        long total = 0L;
        for (RecipeResultNode node : (BuildResult)this.current) {
            RecipeResult recipeResult = node.getResult();
            if (recipeResult == null) continue;
            ++count;
            total += recipeResult.getStamps().getElapsed();
        }
        if (total > 0L) {
            return (double)total / (double)count;
        }
        return 0.0;
    }

    public long getTotalTests() {
        return ((BuildResult)this.current).getTestSummary().getTotal();
    }

    @Override
    public Object getFieldValue(String fieldName) {
        BuildResult currentResult = (BuildResult)this.current;
        if (fieldName.equals("date")) {
            return currentResult.getStamps().getEndTime();
        }
        if (fieldName.equals("state")) {
            return currentResult.getState().toString();
        }
        if (fieldName.equals("id")) {
            return currentResult.getId();
        }
        if (fieldName.equals("elapsed")) {
            return currentResult.getStamps().getElapsed();
        }
        return null;
    }

    public List<BuildResult> getSource() {
        return this.source;
    }
}

