/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.cache.ehcache;

import com.zutubi.pulse.cache.Cache;
import com.zutubi.pulse.util.logging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;

public class EhCache
implements Cache {
    private static final Logger LOG = Logger.getLogger(EhCache.class);
    private final net.sf.ehcache.Cache delegate;

    public EhCache(net.sf.ehcache.Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Can not create an ehcache wrapper around a null cache instance.");
        }
        this.delegate = cache;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Object get(Object key) {
        try {
            Element e = this.delegate.get((Serializable)key);
            if (e != null) {
                return e.getValue();
            }
            return null;
        }
        catch (CacheException e) {
            LOG.warning("Error retrieving cache(" + this.getName() + ")ed object. Key: '" + key + "'", (Throwable)e);
            return null;
        }
    }

    public List getKeys() {
        try {
            return this.delegate.getKeys();
        }
        catch (CacheException e) {
            LOG.error("Error looking up the cache(" + this.getName() + ") keys. Reason: " + e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public void put(Object key, Object value) {
        this.delegate.put(new Element((Serializable)key, (Serializable)value));
    }

    public void remove(Object key) {
        this.delegate.remove((Serializable)key);
    }

    public void removeAll() {
        try {
            this.delegate.removeAll();
        }
        catch (IOException e) {
            LOG.error("Error removing all elements from the cache(" + this.getName() + "). Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    net.sf.ehcache.Cache getDelegate() {
        return this.delegate;
    }
}

