/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap.quartz;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.util.logging.Logger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class SpringJobFactory
implements JobFactory {
    private static final Logger LOG = Logger.getLogger(SpringJobFactory.class);
    private ObjectFactory objectFactory;
    private Scheduler scheduler;

    public Job newJob(TriggerFiredBundle bundle) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Class jobClass = jobDetail.getJobClass();
        try {
            return (Job)this.objectFactory.buildBean(jobClass);
        }
        catch (Exception e) {
            throw new SchedulerException(e);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void init() throws SchedulerException {
        this.scheduler.setJobFactory((JobFactory)this);
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

