/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.AbstractConfigurationManager;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.Data;
import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.MasterConfigurationSupport;
import com.zutubi.pulse.bootstrap.MasterUserPaths;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.bootstrap.SystemConfigurationSupport;
import com.zutubi.pulse.bootstrap.conf.EnvConfig;
import com.zutubi.pulse.bootstrap.conf.VolatileReadOnlyConfig;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.FileConfig;
import com.zutubi.pulse.events.DataDirectoryChangedEvent;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class SimpleMasterConfigurationManager
extends AbstractConfigurationManager
implements MasterConfigurationManager {
    private SystemConfiguration sysConfig;
    private MasterConfiguration appConfig;
    private DatabaseConfig dbConfig;
    private Data data;

    public SystemConfiguration getSystemConfig() {
        if (this.sysConfig == null) {
            File userProps;
            EnvConfig envConfig = this.getEnvConfig();
            Properties systemCopy = new Properties();
            systemCopy.putAll((Map<?, ?>)System.getProperties());
            VolatileReadOnlyConfig system = new VolatileReadOnlyConfig(systemCopy);
            String configPath = envConfig.getDefaultPulseConfig(".pulse");
            if (envConfig.hasPulseConfig()) {
                configPath = envConfig.getPulseConfig();
            }
            if (!(userProps = new File(configPath)).isFile()) {
                return new SystemConfigurationSupport(new Config[]{system});
            }
            FileConfig user = new FileConfig(userProps);
            this.sysConfig = new SystemConfigurationSupport(new Config[]{system, user});
        }
        return this.sysConfig;
    }

    public MasterConfiguration getAppConfig() {
        if (this.appConfig == null) {
            MasterUserPaths paths = this.getUserPaths();
            if (paths == null) {
                return new MasterConfigurationSupport(new Config[0]);
            }
            FileConfig user = new FileConfig(new File(paths.getUserConfigRoot(), "pulse.properties"));
            this.appConfig = new MasterConfigurationSupport(new Config[]{user});
        }
        return this.appConfig;
    }

    public MasterUserPaths getUserPaths() {
        return this.getData();
    }

    public File getDataDirectory() {
        return new File(this.getSystemConfig().getDataPath());
    }

    public File getHomeDirectory() {
        if (this.envConfig.hasPulseHome()) {
            return new File(this.envConfig.getPulseHome());
        }
        return null;
    }

    public DatabaseConfig getDatabaseConfig() throws IOException {
        if (this.dbConfig == null) {
            File configFile = null;
            if (this.getUserPaths() != null && this.getUserPaths().getUserConfigRoot() != null) {
                configFile = new File(this.getUserPaths().getUserConfigRoot(), "database.properties");
            }
            if (configFile == null || !configFile.exists()) {
                configFile = new File(this.getSystemPaths().getConfigRoot(), "database.properties.template");
            }
            this.dbConfig = new DatabaseConfig(IOUtils.read((File)configFile));
            this.dbConfig.setUserPaths(this.getUserPaths());
        }
        return this.dbConfig;
    }

    public Data getData() {
        if (this.data == null) {
            if (!TextUtils.stringSet((String)this.getSystemConfig().getDataPath())) {
                return null;
            }
            this.data = new Data(new File(this.getSystemConfig().getDataPath()));
        }
        return this.data;
    }

    public void setPulseData(File f) {
        this.getSystemConfig().setDataPath(f.getAbsolutePath());
        EventManager eventManager = (EventManager)ComponentContext.getBean((String)"eventManager");
        eventManager.publish((Event)new DataDirectoryChangedEvent((Object)this));
        this.data = null;
    }
}

