/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.upgrade.tasks.SchemaRefactor;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RemoteDatabaseConsole
implements DatabaseConsole,
ApplicationContextAware {
    private DatabaseConfig config;
    private ApplicationContext context;
    private DataSource dataSource;
    private MutableConfiguration hibernateConfig;
    private Properties hibernateProps;

    public RemoteDatabaseConsole(DatabaseConfig config) {
        this.config = config;
    }

    public boolean schemaExists() {
        return JDBCUtils.tableExists((DataSource)this.dataSource, (String)"RESOURCE");
    }

    public void createSchema() throws SQLException {
        SchemaRefactor refactor = new SchemaRefactor(this.hibernateConfig, this.hibernateProps);
        refactor.createSchema();
    }

    public void dropSchema() throws SQLException {
        SchemaRefactor refactor = new SchemaRefactor(this.hibernateConfig, this.hibernateProps);
        refactor.dropSchema();
    }

    public boolean isEmbedded() {
        return false;
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public double getDatabaseUsagePercent() {
        return -1.0;
    }

    public void stop(boolean force) {
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setHibernateConfig(MutableConfiguration config) {
        this.hibernateConfig = config;
    }

    public void setHibernateProperties(Properties props) {
        this.hibernateProps = props;
    }
}

