/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.config.CompositeConfig;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class MasterConfigurationSupport
extends ConfigSupport
implements MasterConfiguration {
    public MasterConfigurationSupport(Config ... config) {
        super((Config)new CompositeConfig(config));
    }

    public boolean isEventLoggingEnabled() {
        return this.getBooleanProperty("log.events", false);
    }

    public void setEventLoggingEnabled(boolean b) {
        this.setBooleanProperty("log.events", b);
    }

    public String getLoggingLevel() {
        return this.getProperty("log.config", "default");
    }

    public void setLoggingLevel(String logConfig) {
        this.setProperty("log.config", logConfig);
    }

    public String getAdminLogin() {
        return this.getProperty("admin.login");
    }

    public void setAdminLogin(String login) {
        this.setProperty("admin.login", login);
    }

    public String getBaseUrl() {
        return this.getProperty("webapp.base.url");
    }

    public void setBaseUrl(String host) {
        if (TextUtils.stringSet((String)host) && host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        this.setProperty("webapp.base.url", host);
    }

    public String getAgentHost() {
        String host = this.getProperty("agent.url");
        if (host == null) {
            String base = this.getBaseUrl();
            if (base != null) {
                try {
                    URL url = new URL(this.getBaseUrl());
                    host = url.getHost();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (host == null) {
                try {
                    InetAddress address = InetAddress.getLocalHost();
                    host = address.getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    host = "localhost";
                }
            }
        }
        return host;
    }

    public void setAgentHost(String url) {
        this.setProperty("agent.url", url);
    }

    public String getHelpUrl() {
        return this.getProperty("help.url", "http://confluence.zutubi.com/display/pulse0102");
    }

    public void setHelpUrl(String helpUrl) {
        this.setProperty("help.url", helpUrl);
    }

    public String getSmtpHost() {
        return this.getProperty("mail.smtp.host");
    }

    public void setSmtpHost(String host) {
        this.setProperty("mail.smtp.host", host);
    }

    public int getSmtpPort() {
        return this.getInteger("mail.smtp.port", -1);
    }

    public void setSmtpPort(int port) {
        this.setInteger("mail.smtp.port", port);
    }

    public boolean getSmtpSSL() {
        return this.getBooleanProperty("mail.smtp.ssl", false);
    }

    public void setSmtpSSL(boolean ssl) {
        this.setBooleanProperty("mail.smtp.ssl", ssl);
    }

    public String getSmtpFrom() {
        return this.getProperty("mail.smtp.from");
    }

    public void setSmtpFrom(String from) {
        this.setProperty("mail.smtp.from", from);
    }

    public String getSmtpPassword() {
        return this.getProperty("mail.smtp.password");
    }

    public void setSmtpPassword(String password) {
        this.setProperty("mail.smtp.password", password);
    }

    public Boolean getJabberForceSSL() {
        return this.getBooleanProperty("jabber.force.ssl", Boolean.FALSE);
    }

    public void setJabberForceSSL(Boolean forceSSL) {
        this.setBooleanProperty("jabber.force.ssl", forceSSL);
    }

    public Boolean getRssEnabled() {
        return this.getBooleanProperty("rss.enabled", Boolean.TRUE);
    }

    public void setRssEnabled(Boolean rssEnabled) {
        this.setBooleanProperty("rss.enabled", rssEnabled);
    }

    public Boolean getAnonymousAccessEnabled() {
        return this.getBooleanProperty("anon.enabled", Boolean.FALSE);
    }

    public void setAnonymousAccessEnabled(Boolean anonEnabled) {
        this.setBooleanProperty("anon.enabled", anonEnabled);
    }

    public Boolean getAnonymousSignupEnabled() {
        return this.getBooleanProperty("signup.enabled", Boolean.FALSE);
    }

    public void setAnonymousSignupEnabled(Boolean signupEnabled) {
        this.setBooleanProperty("signup.enabled", signupEnabled);
    }

    public Boolean getLdapEnabled() {
        return this.getBooleanProperty("ldap.enabled", false);
    }

    public void setLdapEnabled(Boolean enabled) {
        this.setBooleanProperty("ldap.enabled", enabled);
    }

    public String getLdapHostUrl() {
        return this.getProperty("ldap.host");
    }

    public void setLdapHostUrl(String hostUrl) {
        this.setProperty("ldap.host", hostUrl);
    }

    public String getLdapBaseDn() {
        return this.getProperty("ldap.base.dn");
    }

    public void setLdapBaseDn(String baseDn) {
        this.setProperty("ldap.base.dn", baseDn);
    }

    public String getLdapManagerDn() {
        return this.getProperty("ldap.manager.dn");
    }

    public void setLdapManagerDn(String managerDn) {
        this.setProperty("ldap.manager.dn", managerDn);
    }

    public String getLdapManagerPassword() {
        return this.getProperty("ldap.manager.password");
    }

    public void setLdapManagerPassword(String managerPassword) {
        this.setProperty("ldap.manager.password", managerPassword);
    }

    public String getLdapUserFilter() {
        return this.getProperty("ldap.user.filter");
    }

    public void setLdapUserFilter(String userFilter) {
        this.setProperty("ldap.user.filter", userFilter);
    }

    public String getLdapGroupFilter() {
        return this.getProperty("ldap.group.filter");
    }

    public void setLdapGroupFilter(String groupFilter) {
        this.setProperty("ldap.group.filter", groupFilter);
    }

    public String getLdapGroupRoleAttribute() {
        return this.getProperty("ldap.group.role.attribute");
    }

    public void setLdapGroupRoleAttribute(String attribute) {
        this.setProperty("ldap.group.role.attribute", attribute);
    }

    public Boolean getLdapAutoAdd() {
        return this.getBooleanProperty("ldap.auto.add", false);
    }

    public void setLdapAutoAdd(Boolean autoAdd) {
        this.setBooleanProperty("ldap.auto.add", autoAdd);
    }

    public String getLdapEmailAttribute() {
        return this.getProperty("ldap.email.attribute");
    }

    public void setLdapEmailAttribute(String attribute) {
        this.setProperty("ldap.email.attribute", attribute);
    }

    public Boolean getLdapEscapeSpaces() {
        return this.getBooleanProperty("ldap.escape", true);
    }

    public void setLdapEscapeSpaces(Boolean escape) {
        this.setBooleanProperty("ldap.escape", escape);
    }

    public String getLdapGroupBaseDn() {
        return this.getProperty("ldap.group.base.dn");
    }

    public void setLdapGroupBaseDn(String dn) {
        this.setProperty("ldap.group.base.dn", dn);
    }

    public boolean getLdapGroupSearchSubtree() {
        return this.getBooleanProperty("ldap.group.search.subtree", false);
    }

    public void setLdapGroupSearchSubtree(boolean search) {
        this.setBooleanProperty("ldap.group.search.subtree", search);
    }

    public String getSmtpPrefix() {
        return this.getProperty("mail.smtp.prefix");
    }

    public void setSmtpPrefix(String prefix) {
        this.setProperty("mail.smtp.prefix", prefix);
    }

    public String getSmtpUsername() {
        return this.getProperty("mail.smtp.username");
    }

    public void setSmtpUsername(String username) {
        this.setProperty("mail.smtp.username", username);
    }

    public String getJabberHost() {
        return this.getProperty("jabber.host");
    }

    public void setJabberHost(String host) {
        this.setProperty("jabber.host", host);
    }

    public int getJabberPort() {
        return this.getInteger("jabber.port", 5222);
    }

    public void setJabberPort(int port) {
        this.setInteger("jabber.port", port);
    }

    public String getJabberUsername() {
        return this.getProperty("jabber.username");
    }

    public void setJabberUsername(String username) {
        this.setProperty("jabber.username", username);
    }

    public String getJabberPassword() {
        return this.getProperty("jabber.password");
    }

    public void setJabberPassword(String password) {
        this.setProperty("jabber.password", password);
    }

    public Integer getScmPollingInterval() {
        return this.getInteger("scm.polling.interval", 5);
    }

    public void setScmPollingInterval(Integer interval) {
        this.setInteger("scm.polling.interval", interval);
    }

    public long getUnsatisfiableRecipeTimeout() {
        return this.getLong("unsatisfiable.recipe.timeout", 15L);
    }

    public void setUnsatisfiableRecipeTimeout(Long timeout) {
        this.setLong("unsatisfiable.recipe.timeout", timeout);
    }

    public boolean isMasterEnabled() {
        return this.getBooleanProperty("server.agent.enabled", Boolean.TRUE);
    }

    public void setMasterEnabled(Boolean b) {
        this.setBooleanProperty("server.agent.enabled", b);
    }
}

