/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class HSQLDBUtils {
    private static final Logger LOG = Logger.getLogger(HSQLDBUtils.class);
    private static final long TOTAL_DB_SPACE = 0x3FFFFFFF8L;

    public static void shutdown(DataSource dataSource) throws SQLException {
        JDBCUtils.execute((DataSource)dataSource, (String)"SHUTDOWN SCRIPT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateMaxSizeRequired(DataSource dataSource) {
        ResultSet rs;
        CallableStatement stmt;
        Connection con;
        block4: {
            boolean bl;
            con = null;
            stmt = null;
            rs = null;
            try {
                Long scale;
                con = dataSource.getConnection();
                stmt = con.prepareCall("SELECT property_value FROM information_schema.system_properties WHERE property_name = 'hsqldb.cache_file_scale'");
                rs = stmt.executeQuery();
                if (!rs.next() || (scale = JDBCUtils.getLong((ResultSet)rs, (String)"property_value")) == null || scale != 1L) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(stmt);
                    JDBCUtils.close((Connection)con);
                    throw throwable;
                }
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                JDBCUtils.close((Connection)con);
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)stmt);
            JDBCUtils.close((Connection)con);
            return bl;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((Connection)con);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMaxSize(String url) {
        if (!url.startsWith("jdbc:hsqldb:")) {
            throw new IllegalArgumentException("Unexpected embedded hsqldb url: " + url);
        }
        String databasePath = url.substring(12);
        File databasePropertiesFile = new File(databasePath + ".properties");
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(databasePropertiesFile);
            Properties properties = new Properties();
            properties.load(inStream);
            properties.put("hsqldb.cache_file_scale", "8");
            inStream.close();
            outStream = new FileOutputStream(databasePropertiesFile);
            properties.store(outStream, "Updated cache_file_scale");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.close(inStream);
                IOUtils.close(outStream);
                throw throwable;
            }
            IOUtils.close((Closeable)inStream);
            IOUtils.close(outStream);
        }
        IOUtils.close((Closeable)inStream);
        IOUtils.close((Closeable)outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getDatabaseUsagePercent(DataSource dataSource) {
        ResultSet rs;
        CallableStatement stmt;
        Connection con;
        block4: {
            double d;
            con = null;
            stmt = null;
            rs = null;
            try {
                Long freePos;
                con = dataSource.getConnection();
                stmt = con.prepareCall("SELECT file_free_pos FROM information_schema.system_cacheinfo");
                rs = stmt.executeQuery();
                if (!rs.next() || (freePos = JDBCUtils.getLong((ResultSet)rs, (String)"file_free_pos")) == null) break block4;
                d = (double)freePos.longValue() * 100.0 / 1.7179869176E10;
            }
            catch (SQLException e) {
                try {
                    LOG.severe((Throwable)e);
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(stmt);
                    JDBCUtils.close((Connection)con);
                    throw throwable;
                }
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                JDBCUtils.close((Connection)con);
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)stmt);
            JDBCUtils.close((Connection)con);
            return d;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((Connection)con);
        return -1.0;
    }

    public static void compactDatabase(DataSource dataSource) {
        try {
            JDBCUtils.execute((DataSource)dataSource, (String)"CHECKPOINT DEFRAG");
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
        }
    }
}

