/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SetupManager;
import com.zutubi.pulse.bootstrap.StartupException;
import com.zutubi.pulse.bootstrap.StartupManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.bootstrap.WebManager;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.config.FileConfig;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.system.SystemStartedEvent;
import com.zutubi.pulse.freemarker.CustomFreemarkerManager;
import com.zutubi.pulse.security.AcegiSecurityManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStartupManager
implements StartupManager {
    private static final com.zutubi.pulse.util.logging.Logger LOG = com.zutubi.pulse.util.logging.Logger.getLogger(DefaultStartupManager.class);
    private MasterConfigurationManager configurationManager;
    private ObjectFactory objectFactory;
    private static final long NOT_STARTED = -1L;
    private long startTime = -1L;
    private boolean starting = false;
    private List<String> coreContexts;
    private List<String> setupContexts;
    private List<String> startupRunnables = new LinkedList<String>();

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setSetupContexts(List<String> setupContexts) {
        this.setupContexts = setupContexts;
    }

    public void setCoreContexts(List<String> coreContexts) {
        this.coreContexts = coreContexts;
    }

    public void setStartupRunnables(List<String> startupRunnables) {
        this.startupRunnables = startupRunnables;
    }

    public void init() throws StartupException {
        if (this.isSystemStarted()) {
            throw new StartupException("The system has alredy started.");
        }
        if (this.isSystemStarting()) {
            throw new StartupException("The system is currently starting up.");
        }
        try {
            this.starting = true;
            SystemConfiguration config = this.configurationManager.getSystemConfig();
            File configRoot = this.configurationManager.getSystemPaths().getConfigRoot();
            File startupConfigFile = new File(configRoot, "runtime.properties");
            ConfigSupport startupConfig = new ConfigSupport((Config)new FileConfig(startupConfigFile));
            startupConfig.setProperty("webapp.contextPath", config.getContextPath());
            startupConfig.setInteger("webapp.port", Integer.valueOf(config.getServerPort()));
            CustomFreemarkerManager.initialiseLogging();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    Logger.getLogger("").log(Level.SEVERE, "Uncaught exception: " + e.getMessage(), e);
                }
            });
            this.startApplicationSetup();
        }
        catch (Exception e) {
            throw new StartupException((Throwable)e);
        }
    }

    private void startApplicationSetup() throws Exception {
        ComponentContext.addClassPathContextDefinitions((String[])this.coreContexts.toArray(new String[this.coreContexts.size()]));
        ComponentContext.addClassPathContextDefinitions((String[])this.setupContexts.toArray(new String[this.setupContexts.size()]));
        WebManager webManager = (WebManager)ComponentContext.getBean((String)"webManager");
        webManager.deploySetup();
        SetupManager setupManager = (SetupManager)ComponentContext.getBean((String)"setupManager");
        setupManager.startSetupWorkflow();
    }

    @Override
    public void continueApplicationStartup() {
        WebManager webManager = (WebManager)ComponentContext.getBean((String)"webManager");
        AcegiSecurityManager securityManager = (AcegiSecurityManager)ComponentContext.getBean((String)"securityManager");
        securityManager.init();
        this.runStartupTasks();
        webManager.deployMain();
        this.startTime = System.currentTimeMillis();
        EventManager eventManager = (EventManager)ComponentContext.getBean((String)"eventManager");
        eventManager.publish((Event)new SystemStartedEvent((Object)this));
        MasterConfiguration appConfig = this.configurationManager.getAppConfig();
        SystemConfiguration sysConfig = this.configurationManager.getSystemConfig();
        String str = "The server is now available on port %s at context path '%s' [base URL configured as: %s]";
        String msg = String.format(str, sysConfig.getServerPort(), sysConfig.getContextPath(), appConfig.getBaseUrl());
        System.err.println(msg);
    }

    private void runStartupTasks() {
        for (String name : this.startupRunnables) {
            try {
                Runnable instance = (Runnable)this.objectFactory.buildBean(name);
                instance.run();
            }
            catch (Exception e) {
                LOG.warning("Failed to run startup task " + name + ". Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isSystemStarting() {
        return this.starting;
    }

    @Override
    public boolean isSystemStarted() {
        return this.startTime != -1L;
    }

    public long getUptime() {
        if (this.isSystemStarted()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }
}

