/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.spring.SpringObjectFactory;
import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.Data;
import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SetupManager;
import com.zutubi.pulse.bootstrap.SetupState;
import com.zutubi.pulse.bootstrap.StartupException;
import com.zutubi.pulse.bootstrap.StartupManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.bootstrap.SystemConfigurationSupport;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.bootstrap.conf.EnvConfig;
import com.zutubi.pulse.config.PropertiesWriter;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.upgrade.UpgradeManager;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSetupManager
implements SetupManager {
    private MasterConfigurationManager configurationManager;
    private StartupManager startupManager;
    private UserManager userManager;
    private UpgradeManager upgradeManager;
    private List<String> daoContexts;
    private List<String> upgradeContexts;
    private List<String> setupContexts;
    private List<String> startupContexts;
    private List<String> postStartupContexts;
    private SetupState state = SetupState.STARTING;
    private boolean promptShown = false;

    @Override
    public SetupState getCurrentState() {
        return this.state;
    }

    private void showPrompt() {
        if (!this.promptShown) {
            SystemConfigurationSupport systemConfig = (SystemConfigurationSupport)this.configurationManager.getSystemConfig();
            String baseUrl = this.configurationManager.getAppConfig().getBaseUrl();
            if (!TextUtils.stringSet((String)baseUrl)) {
                baseUrl = systemConfig.getHostUrl();
            }
            System.err.println("Now go to " + baseUrl + " and follow the prompts.");
            this.promptShown = true;
        }
    }

    @Override
    public void startSetupWorkflow() throws IOException {
        this.state = SetupState.STARTING;
        try {
            this.createExternalConfigFileIfRequired();
        }
        catch (IOException e) {
            System.err.println("WARNING: " + e.getMessage());
        }
        if (this.isDataRequired()) {
            this.state = SetupState.DATA;
            this.showPrompt();
            return;
        }
        this.requestDataComplete();
    }

    private void createExternalConfigFileIfRequired() throws IOException {
        File configFile;
        EnvConfig envConfig = this.configurationManager.getEnvConfig();
        SystemConfiguration sysConfig = this.configurationManager.getSystemConfig();
        String externalConfig = envConfig.getPulseConfig();
        if (!TextUtils.stringSet((String)externalConfig)) {
            externalConfig = envConfig.getDefaultPulseConfig(".pulse");
        }
        if (!(configFile = new File(externalConfig)).isAbsolute()) {
            configFile = configFile.getCanonicalFile();
        }
        if (!configFile.isFile()) {
            SystemPaths paths = this.configurationManager.getSystemPaths();
            File configTemplate = new File(paths.getConfigRoot(), "config.properties.template");
            IOUtils.copyTemplate((File)configTemplate, (File)configFile);
            Properties props = new Properties();
            props.setProperty("webapp.contextPath", "/");
            props.setProperty("webapp.port", "8080");
            props.setProperty("pulse.data", sysConfig.getDataPath() != null ? sysConfig.getDataPath() : "");
            PropertiesWriter writer = new PropertiesWriter();
            writer.write(configFile, props);
        }
    }

    @Override
    public void requestDataComplete() throws IOException {
        Data d = this.configurationManager.getData();
        if (!d.isInitialised()) {
            this.configurationManager.getData().init(this.configurationManager.getSystemPaths());
        }
        this.state = SetupState.STARTING;
        if (this.isLicenseRequired()) {
            this.state = SetupState.LICENSE;
            this.showPrompt();
            return;
        }
        this.requestLicenseComplete();
    }

    @Override
    public void requestLicenseComplete() {
        this.state = SetupState.STARTING;
        this.loadContexts(this.daoContexts);
        DatabaseConsole databaseConsole = (DatabaseConsole)ComponentContext.getBean((String)"databaseConsole");
        if (!databaseConsole.schemaExists()) {
            try {
                databaseConsole.createSchema();
            }
            catch (SQLException e) {
                throw new StartupException("Failed to create the database schema. Cause: " + e.getMessage());
            }
        }
        this.loadContexts(this.upgradeContexts);
        if (this.isUpgradeRequired()) {
            this.state = SetupState.UPGRADE;
            this.showPrompt();
            return;
        }
        this.updateVersionIfNecessary();
        this.requestUpgradeComplete();
    }

    @Override
    public void requestUpgradeComplete() {
        this.state = SetupState.STARTING;
        ComponentContext.pop();
        this.loadContexts(this.setupContexts);
        if (this.isSetupRequired()) {
            this.state = SetupState.SETUP;
            return;
        }
        this.requestSetupComplete();
    }

    @Override
    public void requestSetupComplete() {
        this.state = SetupState.STARTING;
        this.loadContexts(this.startupContexts);
        this.loadContexts(this.postStartupContexts);
        this.startupManager.continueApplicationStartup();
    }

    private void loadContexts(List<String> contexts) {
        ComponentContext.addClassPathContextDefinitions((String[])contexts.toArray(new String[contexts.size()]));
        ComponentContext.autowire((Object)this);
        SpringObjectFactory objFact = (SpringObjectFactory)ComponentContext.getBean((String)"xworkObjectFactory");
        if (objFact != null) {
            objFact.setApplicationContext(ComponentContext.getContext());
        }
    }

    private boolean isDataRequired() {
        return this.configurationManager.getData() == null;
    }

    private boolean isLicenseRequired() {
        return !LicenseHolder.hasAuthorization("canRunPulse");
    }

    private boolean isUpgradeRequired() {
        return this.upgradeManager.isUpgradeRequired(this.configurationManager.getData());
    }

    private boolean isSetupRequired() {
        return this.userManager.getUserCount() == 0;
    }

    private void updateVersionIfNecessary() {
        Data d = this.configurationManager.getData();
        Version dataVersion = d.getVersion();
        if (dataVersion.getBuildNumberAsInt() < Version.getVersion().getBuildNumberAsInt()) {
            d.updateVersion(Version.getVersion());
        }
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setStartupManager(StartupManager startupManager) {
        this.startupManager = startupManager;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setDaoContexts(List<String> daoContexts) {
        this.daoContexts = daoContexts;
    }

    public void setSetupContexts(List<String> setupContexts) {
        this.setupContexts = setupContexts;
    }

    public void setStartupContexts(List<String> startupContexts) {
        this.startupContexts = startupContexts;
    }

    public void setPostStartupContexts(List<String> postStartupContexts) {
        this.postStartupContexts = postStartupContexts;
    }

    public void setUpgradeContexts(List<String> upgradeContexts) {
        this.upgradeContexts = upgradeContexts;
    }
}

