/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.Data;
import com.zutubi.pulse.bootstrap.DefaultSystemPaths;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.test.PulseTestCase;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;
import java.io.IOException;

public class DataTest
extends PulseTestCase {
    private File dataDir;

    public DataTest() {
    }

    public DataTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dataDir = FileSystemUtils.createTempDir((String)DataTest.class.getName(), (String)"");
        this.dataDir.delete();
    }

    protected void tearDown() throws Exception {
        this.removeDirectory(this.dataDir);
        super.tearDown();
    }

    public void testInitialiseData() throws IOException {
        Data data = new Data(this.dataDir);
        DataTest.assertFalse((boolean)data.isInitialised());
        DataTest.assertTrue((boolean)this.dataDir.mkdirs());
        DataTest.assertFalse((boolean)data.isInitialised());
        data.init((SystemPaths)new DefaultSystemPaths(new File("."), new File(".")));
        DataTest.assertTrue((boolean)data.isInitialised());
        DataTest.assertTrue((boolean)this.dataDir.exists());
        DataTest.assertTrue((boolean)new File(this.dataDir, "pulse.config.properties").exists());
    }

    public void testVersionDetails() throws IOException {
        Data data = new Data(this.dataDir);
        data.init((SystemPaths)new DefaultSystemPaths(new File("."), new File(".")));
        Version v = Version.getVersion();
        Version dataVersion = data.getVersion();
        DataTest.assertEquals((String)v.getBuildNumber(), (String)dataVersion.getBuildNumber());
        DataTest.assertEquals((String)v.getVersionNumber(), (String)dataVersion.getVersionNumber());
    }
}

