/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.bootstrap;

import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.bootstrap.HSQLDBUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.beans.factory.FactoryBean;

public class DataSourceBeanFactory
implements FactoryBean {
    private BasicDataSource dataSource;
    private DatabaseConfig databaseConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        if (this.dataSource == null) {
            DataSourceBeanFactory dataSourceBeanFactory = this;
            synchronized (dataSourceBeanFactory) {
                if (this.dataSource == null) {
                    this.dataSource = this.createDataSource();
                    if (this.databaseConfig.getDriverClassName().contains(".hsqldb.")) {
                        this.checkEmbeddedSizeRequirements();
                    }
                }
            }
        }
        return this.dataSource;
    }

    private void checkEmbeddedSizeRequirements() throws IOException, SQLException {
        if (this.databaseConfig.getUrl().startsWith("jdbc:hsqldb:mem:")) {
            return;
        }
        if (HSQLDBUtils.updateMaxSizeRequired((DataSource)this.dataSource)) {
            HSQLDBUtils.shutdown((DataSource)this.dataSource);
            this.dataSource.close();
            HSQLDBUtils.updateMaxSize(this.databaseConfig.getUrl());
            this.dataSource = this.createDataSource();
        }
    }

    private BasicDataSource createDataSource() throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.databaseConfig.getDriverClassName());
        dataSource.setUrl(this.databaseConfig.getUrl());
        dataSource.setUsername(this.databaseConfig.getUsername());
        dataSource.setPassword(this.databaseConfig.getPassword());
        Properties connectionProperties = this.databaseConfig.getConnectionProperties();
        for (Object o : connectionProperties.keySet()) {
            String propertyName = (String)o;
            dataSource.addConnectionProperty(propertyName, connectionProperties.getProperty(propertyName));
        }
        return dataSource;
    }

    public Class getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void close() throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }

    public void setDatabaseConfig(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }
}

